#include <iostream>
#include <cmath>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <queue>
#include <deque>
#include <iomanip>
#include <cassert>
#include <random>
#include <climits>

#define int long long

using namespace std;

const int MAXN = 3000;

void solve() {
    int n, l;
    cin >> n >> l;
    l = abs(l);
    vector<int> a(n + 1);
    for (int i = 1; i <= n; ++i) {
        cin >> a[i];
    }
    vector<int> c(n + 1);
    for (int i = 1; i <= n; ++i) {
        cin >> c[i];
    }
    vector<int> dp1(MAXN + 1, 1e18);
    vector<int> dp2(MAXN + 1, 1e18);
    dp1[0] = 0;
    for (int i = 1; i <= n; ++i) {
        for (int j = 0; j <= MAXN; ++j) {
            if (dp1[j] == 1e18) {
                continue;
            }
            dp2[j] = min(dp2[j], dp1[j]);
            int x = __gcd(j, a[i]);
            dp2[x] = min(dp2[x], dp1[j] + c[i]);
        }
        //cout << dp2[5] << '\n';
        for (int j = 0; j <= MAXN; ++j) {
            dp1[j] = dp2[j];
            dp2[j] = 1e18;
        }
    }
    int ans = 1e18;
    for (int i = 1; i <= l; ++i) {
        if (l % i == 0) {
            ans = min(ans, dp1[i]);
        }
    }
    if (ans == 1e18) {
        cout << -1 << '\n';
        return;
    }
    cout << ans << '\n';
}
/*
5
3 5
2 4 6
3 1 2
2 555
5 9
7 9
3 12
6 8 14
100 3 5
4 13
6 10 15 13
4 3 2 100
4 -21
7 7 9 4
5 1 10 10
*/

signed main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    int t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}
