from collections import deque 

def solve():
    n = int(input())
    song_q = deque()
    for _ in range(n):
        name, length_str = input().split()
        song_q.append((name, int(length_str)))

    m = int(input())
    events = []

    for _ in range(m):
        time_str, name, length_str = input().split()
        events.append((int(time_str), name, int(length_str)))

    current_time = 0 
    current_song_end_time = 0
    event_idx = 0

    while event_idx < m or len(song_q) > 0:
        if current_time >= current_song_end_time:
            while event_idx < m and events[event_idx][0] <= current_time: 
                t, name, length = events[event_idx]
                song_q.appendleft((name, length))
                event_idx += 1

            if len(song_q) > 0:
                name, length = song_q.popleft()
                start_time = current_time 
                current_song_end_time = current_time + length 
                print(f"{name} {start_time}")
            else:
                if event_idx < m:
                    current_time = events[event_idx][0]
                else:
                    break 

        else:
            next_event_time = float("inf")
            if event_idx < m:
                next_event_time = events[event_idx][0]

            if next_event_time < current_song_end_time: 
                current_time = next_event_time
                while event_idx < m and events[event_idx][0] == current_time: 
                    t, name, length = events[event_idx]
                    song_q.appendleft((name, length))
                    event_idx += 1
            else:
                current_time = current_song_end_time 

solve()