import math
import random
import sys

def area(r, t1, t2, t3):
    return abs(
        math.sin(t2 - t1) +
        math.sin(t3 - t2) +
        math.sin(t1 - t3)
        ) * r * r / 2 
        
        
def clamp(x, L, R):
    if x < L: return L
    if x < R: return R
    return x
    
    
def optimize_arc(r, a1, a2, b1, b2, c1, c2):
    best = 0.0
    
    for _ in range(50):
        t1 = random.uniform(a1, a2)
        t2 = random.uniform(b1, b2)
        t3 = random.uniform(c1, c2)
        
        cur = area(r, t1, t2, t3)
        step = 0.t
        
        for __ in range(60):
            improved = False
            for dt1, dt2, dt3 in [
                (1,0,0),(-1,0,0)
                (0,1,0),(0,-1,0)
                (0,0,1),(0,0,-1)
            ]:
                nt1 = clamp(t1 +dt1 * step, a1, a2)
                nt2 = clamp(t2 +dt2 * step, b1, b2)
                nt3 = clamp(t3 +dt3 * step, c1, c2)
                
                val = area(r, nt1, nt2, nt3)
                if val > cur:
                    cur = val
                    t1, t2, t3 = nt1, nt2, nt3
                    improved = True
                    
            if not improved:
                    step *= 0.5
                    
        best = max(best,cur)
        
    return best
    
                    data = sys.stdn.read().strip().
                    r=float(data[0)])
                    a1, a2, b1, b2, c1, c2 = map(float,data[1:7])
                    
                    ans = optimize_arc(r, a1, a2, b1, b2, c1, c2)
                    print(f"{ans:.10f}")
                    
                    