#include<iostream>
#include<vector>
#include<algorithm>
#include<string>
#include<cmath>
#include<unordered_map>
#include<deque>
#include<map>

using namespace std;
using ll = long long;
using ld = long double;
using ull = unsigned long long;
const ll MOD = 998244353, INF = 2e14;

#define lv(v) v + 1
#define rv(v) v + 2 * (m - l)

struct SegmentTree {
    vector<ll> t, add;
    vector<ll> b;

    SegmentTree(vector<ll> a) {
        b = a;
        t.resize(2 * a.size());
        add.resize(2 * a.size());
        build(0, 0, a.size());
    }

    void build(ll v, ll l, ll r) {
        if(r - l == 1) {
            t[v] = b[l];
            return;
        }
        ll m = (r + l) / 2;
        build(lv(v), l, m);
        build(rv(v), m, r);
        t[v] = min(t[lv(v)], t[rv(v)]);
    }

    void push(ll v, ll l, ll r) {
        ll m = (r + l) / 2;
        add[lv(v)] += add[v];
        add[rv(v)] += add[v];
        t[lv(v)] += add[v];
        t[rv(v)] += add[v];
        add[v] = 0;
    }

    void update(ll v, ll l, ll r, ll ql, ll qr, ll x) {
        if (ql >= r || qr <= l) return;
        if(ql <= l && r <= qr) {
            add[v] += x;
            t[v] += x;
            return;
        }
        ll m = (r + l) / 2;
        push(v, l, r);
        update(lv(v), l, m, ql, qr, x);
        update(rv(v), m, r, ql, qr, x);
        t[v] = min(t[lv(v)], t[rv(v)]);
    }

    ll lwr(ll v, ll l, ll r, ll x) {
        if (r - l == 1) return l;
        ll m = (r + l) / 2;
        push(v, l, r);
        if(t[v] <= x) {
            return lwr(rv(v), m, r, x);
        }
        else {
            return lwr(lv(v), l, m, x);
        }
    }
};

struct el {
    ll t;
    string s;
    ll l;

    el() = default;
};

bool cmp(el a, el b) {
    return a.t < b.t;
}

void solve() {
    ll n;
    cin >> n;
    vector<ll> t(n + 1);
    deque<el> a(n);
    for(ll i = 0;i < n;i++) {
        string s;
        ll tim;
        cin >> s >> tim;
        a[i] = {t[i], s, tim };
        t[i + 1] += tim;
    }
    ll q;
    cin >> q;
    deque<el> b;
    deque<el> tmp;
    for(ll i = 0;i < q;i++) {
        ll t, len;
        string s;
        cin >> t >> s >> len;
        if(!b.empty() && b.back().t == t) {
            if(!tmp.empty())tmp.emplace_front(t, s, len);
            else tmp.emplace_back(t, s, len);
        }
        else {
            for(auto j : tmp) {
                b.push_back(j);
            }
            tmp.clear();
            tmp.emplace_back(t, s, len);
        }
    }
    sort(b.begin(), b.end(), cmp);
    vector<pair<string, ll>> ans(n + q);
    ll time = 0;
    for(ll i = 0;i < n + q;i++) {
        if((!b.empty() && !a.empty() && b.front().t <= a.front().t) || a.empty()) {
            ans[i] = { b.front().s, time};
            time += b.front().l;
            b.pop_front();
        }
        else{
            ans[i] = { a.front().s, a.front().t + time};
            time += a.front().l;
            a.pop_front();
        }
    }
    for (ll i = 0; i < n + q; i++) cout << ans[i].first << ' ' << ans[i].second << '\n';
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    int t12345 = 1;
   // cin >> t12345;
    while (t12345--) {
        solve();
        cout << '\n';
    }
    return 0;
}
