import math
from functools import reduce

def solve():
    n = int(input())
    a = list(map(int, input().split()))
    
    MOD = 998244353
    
    def lcm(x, y):
        return x * y // math.gcd(x, y)
    
    def compute_gcd(elements):
        if not elements:
            return 0
        return reduce(math.gcd, elements)
    
    result = 0
    
    for i in range(n):
        lcm_val = a[i]
        
        for j in range(i, n):
            if j > i:
                lcm_val = lcm(lcm_val, a[j])
            
            left_elements = a[:i]
            right_elements = a[j + 1:]
            
            gcd_val = compute_gcd(left_elements + right_elements)
            gcd_val = math.gcd(gcd_val, lcm_val)
            
            result = (result + gcd_val) % MOD
    
    print(result)

if __name__ == "__main__":
    solve()