import math

def solve():
    n = int(input())
    a = list(map(int, input().split()))
    
    MOD = 998244353
    
    def lcm(x, y):
        g = math.gcd(x, y)
        return x // g * y
    
    prefix_gcd = [0] * (n + 1)
    suffix_gcd = [0] * (n + 1)
    
    for i in range(n):
        prefix_gcd[i + 1] = math.gcd(prefix_gcd[i], a[i])
    
    for i in range(n - 1, -1, -1):
        suffix_gcd[i] = math.gcd(suffix_gcd[i + 1], a[i])
    
    result = 0
    
    for i in range(n):
        lcm_val = a[i]
        
        for j in range(i, n):
            if j > i:
                new_lcm = lcm(lcm_val, a[j])
                if new_lcm == lcm_val:
                    pass
                lcm_val = new_lcm
            
            gcd_val = math.gcd(prefix_gcd[i], suffix_gcd[j + 1])
            gcd_val = math.gcd(gcd_val, lcm_val)
            
            result = (result + gcd_val) % MOD
    
    print(result)

if __name__ == "__main__":
    solve()