import sys

# Функция для поиска максимальной длины палиндрома
def find_max_palindromic_length(arr, n):
    if n == 0:
        return 0
    
    max_len = 1
    
    for i in range(n):
        L = 0
        while i - L >= 0 and i + L < n and arr[i - L] == arr[i + L]:
            is_left_valid = True
            if L > 0 and arr[i - L] > arr[i - L + 1]:
                is_left_valid = False
            
            is_right_valid = True
            if L > 0 and arr[i + L - 1] < arr[i + L]:
                is_right_valid = False

            if is_left_valid and is_right_valid:
                 L += 1
            else:
                break
        
        max_len = max(max_len, 2 * (L - 1) + 1)

    return max_len

def solve():
    # --- ПРЯМОЕ ПРИСВОЕНИЕ ДАННЫХ ---
    # Входные данные: 5, 3 4 3 2 1, 3, 3 5, 4 4, 5 3
    N = 5
    A = [3, 4, 3, 2, 1]
    Q = 3 # (Это число технически не используется, но мы его оставим)
    queries = [
        (3, 5), 
        (4, 4), 
        (5, 3)
    ]
    # ---------------------------------
    
    results = []
    
    # Начальное состояние
    results.append(find_max_palindromic_length(A, N))
    
    # Запросы
    for i_query, x_query in queries:
        # Индекс в массиве A (1-based -> 0-based)
        index = i_query - 1
        A[index] = x_query
        max_len = find_max_palindromic_length(A, N)
        results.append(max_len)

    # Вывод результата
    sys.stdout.write('\n'.join(map(str, results)) + '\n')

if __name__ == "__main__":
    solve()