import sys

def find_max_palindromic_length(arr, n):
    if n == 0:
        return 0
    
    max_len = 1
    
    for i in range(n):
        L = 0
        while True:
            left_idx = i - L
            right_idx = i + L
            
            if left_idx < 0 or right_idx >= n:
                break
            
            if arr[left_idx] != arr[right_idx]:
                break
                
            if L > 0:
                if arr[left_idx] > arr[left_idx + 1]:
                    break
                
                if arr[right_idx - 1] < arr[right_idx]:
                    break
            
            L += 1
            
        current_len = 2 * (L - 1) + 1
        max_len = max(max_len, current_len)

    return max_len

def solve():
    try:
        input_data = sys.stdin.read().split()
        
        if not input_data:
            return

        N = int(input_data[0])
        A = [int(x) for x in input_data[1:N+1]]
        
        Q_start_index = N + 1
        Q = int(input_data[Q_start_index])
        
        queries = []
        current_index = Q_start_index + 1
        for _ in range(Q):
            i = int(input_data[current_index])
            x = int(input_data[current_index + 1])
            queries.append((i, x))
            current_index += 2
            
    except Exception:
        return
    
    results = []
    
    results.append(find_max_palindromic_length(A, N))
    
    for i_query, x_query in queries:
        index = i_query - 1
        A[index] = x_query
        
        max_len = find_max_palindromic_length(A, N)
        results.append(max_len)

    sys.stdout.write('\n'.join(map(str, results)) + '\n')

if __name__ == "__main__":
    solve()