import sys
input = sys.stdin.readline

class Node:
    slots = ("lval", "rval", "lrun", "rrun", "best", "len")

    def __init__(self, v=0):
        self.lval = self.rval = v
        self.lrun = self.rrun = 1
        self.best = 1
        self.len = 1


def merge(a: Node, b: Node) -> Node:
    if a.len == 0: return b
    if b.len == 0: return a

    r = Node()
    r.len = a.len + b.len
    r.lval = a.lval
    r.rval = b.rval

    # left run
    r.lrun = a.lrun
    if a.lrun == a.len and a.rval - 1 == b.lval:
        r.lrun += b.lrun

    # right run
    r.rrun = b.rrun
    if b.rrun == b.len and b.lval - 1 == a.rval:
        r.rrun += a.rrun

    r.best = max(a.best, b.best)
    if a.rval - 1 == b.lval:
        r.best = max(r.best, a.rrun + b.lrun - 1)

    return r


n = int(input())
a = list(map(int, input().split()))
q = int(input())

N = 1
while N < n:
    N <<= 1

tree = [Node() for _ in range(2 * N)]

def build():
    for i in range(n):
        tree[N + i] = Node(a[i])
    for i in range(n, N):
        tree[N + i].len = 0
    for i in range(N - 1, 0, -1):
        tree[i] = merge(tree[i << 1], tree[i << 1 | 1])


def update(i, v):
    p = N + i
    tree[p] = Node(v)
    p //= 2
    while p:
        tree[p] = merge(tree[p << 1], tree[p << 1 | 1])
        p //= 2


build()
print(tree[1].best)
for _ in range(q):
    i, x = map(int, input().split())
    update(i - 1, x)
    print(tree[1].best)
