# Простой корректный вариант (пересчитываем всё после каждого обновления).
# Подойдёт для проверки и для небольших входов / примеров.
import sys
input = sys.stdin.readline

def max_step_pal(a):
    n = len(a)
    # L[i] = длина возрастающей на +1 подпоследовательности, оканчивающейся в i
    L = [1] * n
    for i in range(1, n):
        if a[i] == a[i-1] + 1:
            L[i] = L[i-1] + 1
        else:
            L[i] = 1
    # R[i] = длина убывающей на -1 подпоследовательности, начинающейся в i
    R = [1] * n
    for i in range(n-2, -1, -1):
        if a[i] == a[i+1] + 1:
            R[i] = R[i+1] + 1
        else:
            R[i] = 1
    best = 0
    for i in range(n):
        cur = min(L[i], R[i]) * 2 - 1
        if cur > best:
            best = cur
    return best

# Чтение входа в формате задачи
data = sys.stdin.read().strip().split()
if not data:
    sys.exit(0)
it = iter(data)
n = int(next(it))
a = [int(next(it)) for _ in range(n)]
q = int(next(it))
# печатаем начальный ответ и ответы после каждого обновления
print(max_step_pal(a))
for _ in range(q):
    idx = int(next(it)) - 1
    val = int(next(it))
    a[idx] = val
    print(max_step_pal(a))
