MOD = 10**9 + 7

t = int(input())
for _ in range(t):
    n, m, L = map(int, input().split())

    edges = []
    for _ in range(m):
        u, v, w = map(int, input().split())
        edges.append((u - 1, v - 1, w))

    d = list(map(int, input().split()))

    ok = True
    ans = 1

    # для проверки существования правильных "родителей"
    parent_ok = [False] * n
    parent_ok[0] = True

    for u, v, w in edges:
        k = abs(d[u] - d[v])     # минимально допустимый вес ребра

        if w != 0:  # известный вес
            if w < k:
                ok = False
                break

            # Проверяем, даёт ли это ребро путь ровно d[i]
            if d[u] + w == d[v]:
                parent_ok[v] = True
            if d[v] + w == d[u]:
                parent_ok[u] = True

        else:  # вес неизвестный
            if k > L:   # нет допустимого веса
                ok = False
                break

            # количество вариантов для этого ребра
            ans = ans * (L - k + 1) % MOD

            # может быть родителем, если вес = k
            if d[u] + k == d[v]:
                parent_ok[v] = True
            if d[v] + k == d[u]:
                parent_ok[u] = True

    # проверяем, что у каждой вершины есть кратчайший путь
    for i in range(n):
        if not parent_ok[i]:
            ok = False
            break

    print(ans if ok else 0)
