import sys
import math

input = sys.stdin.readline

t = int(input())
for _ in range(t):
    n, L = map(int, input().split())
    xs = list(map(int, input().split()))
    cs = list(map(int, input().split()))

    dp = {}  # gcd -> min cost

    for x, cost in zip(xs, cs):
        new_dp = {}
        # Начинаем только с текущего прыжка
        new_g = x
        new_dp[new_g] = cost

        # Пробуем добавить к существующим
        for g, prev_cost in dp.items():
            g2 = math.gcd(g, x)
            new_cost = prev_cost + cost
            if g2 not in new_dp or new_dp[g2] > new_cost:
                new_dp[g2] = new_cost

        # Сливаем new_dp с dp
        for g, cost_g in new_dp.items():
            if g not in dp or dp[g] > cost_g:
                dp[g] = cost_g

    ans = -1
    for g, cost in dp.items():
        if L % g == 0:
            ans = cost if ans == -1 else min(ans, cost)

    print(ans)
