#include <bits/stdc++.h>
using namespace std;
using int64 = long long;
const int64 MOD = 998244353;
const __int128 LCM_INF = (__int128)4e18; // cap for lcm to avoid overflow

int64 gcd64(int64 a, int64 b) {
    if (a == 0) return b;
    if (b == 0) return a;
    return std::gcd(a, b);
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    if (!(cin >> n)) return 0;
    vector<int64> a(n+1);
    for (int i = 1; i <= n; ++i) cin >> a[i];

    // prefix and suffix gcds
    vector<int64> pref(n+1), suf(n+2);
    pref[0] = 0;
    for (int i = 1; i <= n; ++i) pref[i] = gcd64(pref[i-1], a[i]);
    suf[n+1] = 0;
    for (int i = n; i >= 1; --i) suf[i] = gcd64(suf[i+1], a[i]);

    auto addmod = [&](int64 &x, int64 v) {
        x += v;
        if (x >= MOD) x -= MOD;
    };

    int64 ans = 0;

    // For each starting i, build compressed list of (lcm, l, r)
    for (int i = 1; i <= n; ++i) {
        int64 prefG = pref[i-1];
        vector<pair<long long, pair<int,int>>> chunks; // (lcm, (l,r))
        __int128 curL = 1;
        int l = i;
        for (int j = i; j <= n; ++j) {
            int64 aj = a[j];
            // compute newL = lcm(curL, aj) but careful with overflow
            int64 curL64 = (curL > (__int128)LLONG_MAX ? LLONG_MAX : (long long)curL);
            int64 g = gcd64(curL64, aj);
            __int128 tmp = curL;
            // curL = curL / g * aj, but do with __int128
            if (tmp == LCM_INF) {
                // already saturated
                tmp = LCM_INF;
            } else {
                tmp = tmp / g;
                tmp = tmp * aj;
                if (tmp > LCM_INF) tmp = LCM_INF;
            }
            long long newL64 = (tmp > (__int128)LLONG_MAX ? LLONG_MAX : (long long)tmp);

            if (chunks.empty() || chunks.back().first != newL64) {
                // start new chunk
                chunks.push_back({newL64, {j, j}});
            } else {
                // extend last chunk's r
                chunks.back().second.second = j;
            }
            curL = tmp;
        }

        // For each chunk (same L on range [l..r]), iterate j in it and add contributions
        for (auto &ch : chunks) {
            long long L = ch.first;
            int Lpos = ch.second.first;
            int Rpos = ch.second.second;
            for (int j = Lpos; j <= Rpos; ++j) {
                int64 rightG = suf[j+1]; // gcd of elements after j
                int64 outG = gcd64(prefG, rightG);
                int64 cur = gcd64(outG, L);
                ans += cur % MOD;
                if (ans >= (1LL<<62)) ans %= MOD; // avoid overflow
            }
        }
        ans %= MOD;
    }

    cout << ans % MOD << "\n";
    return 0;
}
