#include <bits/stdc++.h>
using namespace std;

double r;
double a1_, a2_, b1_, b2_, c1_, c2_;

inline double tri_area(double t1, double t2, double t3){
    double x1 = r * cos(t1), y1 = r * sin(t1);
    double x2 = r * cos(t2), y2 = r * sin(t2);
    double x3 = r * cos(t3), y3 = r * sin(t3);
    double cross = (x2-x1)*(y3-y1) - (y2-y1)*(x3-x1);
    return fabs(cross)*0.5;
}

double best_for_pair(double t1, double t3){
    // optimal t2 is midpoint if inside [b1_,b2_], otherwise one of ends
    double mid = 0.5*(t1 + t3);
    if (mid >= b1_ && mid <= b2_) return tri_area(t1, mid, t3);
    double v1 = tri_area(t1, b1_, t3);
    double v2 = tri_area(t1, b2_, t3);
    return max(v1, v2);
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    if(!(cin>>r)) return 0;
    cin >> a1_ >> a2_ >> b1_ >> b2_ >> c1_ >> c2_;

 
    double best = 0;
    vector<double> A = {a1_, (a1_+a2_)/2.0, a2_};
    vector<double> C = {c1_, (c1_+c2_)/2.0, c2_};
    for(double x : A) for(double z : C){
        best = max(best, best_for_pair(x,z));
    }
 
    vector<double> B = {b1_, b2_};
    for(double x : {a1_, a2_}) for(double y : B) for(double z : {c1_, c2_})
        best = max(best, tri_area(x,y,z));

   
    vector<pair<double,double>> seeds;
    for(double x : A) for(double z : C) seeds.emplace_back(x,z);

    for(auto s : seeds){
        double t1 = s.first, t3 = s.second;
        double cur = best_for_pair(t1,t3);
        double step = max(a2_-a1_, c2_-c1_);
        if(step <= 0) step = 1e-3;
        while(step > 1e-9){
            bool improved = false;
       
            for(int dx = -1; dx <= 1; ++dx){
                for(int dz = -1; dz <= 1; ++dz){
                    if(dx==0 && dz==0) continue;
                    double nt1 = t1 + dx*step;
                    double nt3 = t3 + dz*step;
               
                    if(nt1 < a1_) nt1 = a1_;
                    if(nt1 > a2_) nt1 = a2_;
                    if(nt3 < c1_) nt3 = c1_;
                    if(nt3 > c2_) nt3 = c2_;
                    double val = best_for_pair(nt1, nt3);
                    if(val > cur + 1e-15){
                        cur = val;
                        t1 = nt1;
                        t3 = nt3;
                        improved = true;
                    }
                }
            }
            if(!improved) step *= 0.5;
        }
        best = max(best, cur);
    }

    cout.setf(std::ios::fixed); cout<<setprecision(10)<<best<<"\n";
    return 0;
}
