#include <bits/stdc++.h>
using namespace std;
using int64 = long long;
using u128 = __uint128_t;

bool isPrime(int64 n){
    if(n < 2) return false;
    for(int64 p: {2,3,5,7,11,13,17,19,23,29,31}){
        if(n == p) return true;
        if(n % p == 0) return n == p;
    }
    auto pw = [&](u128 a, u128 d, u128 mod){
        u128 r = 1;
        while(d){
            if(d&1) r = (r*a)%mod;
            a = (a*a)%mod;
            d >>= 1;
        }
        return r;
    };
    auto check = [&](int64 a, int64 s, int64 d, int64 n){
        u128 x = pw(a, d, n);
        if(x == 1 || x == n-1) return true;
        for(int i=1;i<s;i++){
            x = (x*x)%n;
            if(x == n-1) return true;
        }
        return false;
    };
    int64 d = n-1, s = 0;
    while((d&1)==0) d >>= 1, s++;
    for(int64 a: {2,325,9375,28178,450775,9780504,1795265022}){
        if(a % n == 0) continue;
        if(!check(a, s, d, n)) return false;
    }
    return true;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t; cin >> t;
    while(t--){
        int n; cin >> n;
        int64 x;
        int composite = 0;
        for(int i=0;i<n;i++){
            cin >> x;
            if(!isPrime(x)) composite++; 
        }
        cout << (composite % 2 ? "Yes" : "No") << "\n";
    }
    return 0;
}
