#include <bits/stdc++.h>
using namespace std;
using ll = long long;

bool check_and_print(int n, const vector<int>& vals) {
    // vals.size() == n*n, row-major
    vector<ll> row(n,0), col(n,0);
    ll d1 = 0, d2 = 0;
    for(int i=0, p=0;i<n;i++){
        for(int j=0;j<n;j++,p++){
            int v = vals[p];
            row[i] += v;
            col[j] += v;
            if(i==j) d1 += v;
            if(i+j==n-1) d2 += v;
        }
    }
    unordered_set<ll> S;
    S.reserve(2*n+4);
    for(int i=0;i<n;i++){
        if(!S.insert(row[i]).second) return false;
    }
    for(int j=0;j<n;j++){
        if(!S.insert(col[j]).second) return false;
    }
    if(!S.insert(d1).second) return false;
    if(!S.insert(d2).second) return false;

    // ok, print
    cout << "Yes\n";
    for(int i=0, p=0;i<n;i++){
        for(int j=0;j<n;j++,p++){
            if(j) cout << ' ';
            cout << vals[p];
        }
        cout << '\n';
    }
    return true;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    if(!(cin>>n)) return 0;
    if(n==1 || n==2){
        cout << "No\n";
        return 0;
    }

    int N = n*n;
    vector<int> base(N);
    for(int i=0;i<N;i++) base[i]=i+1;

    // 1) try simple row-major 1..n^2
    if(check_and_print(n, base)) return 0;

    // 2) try snake (zigzag rows)
    vector<int> snake(N);
    for(int i=0,p=0;i<n;i++){
        if(i%2==0){
            for(int j=0;j<n;j++) snake[p++]= i*n + j + 1;
        }else{
            for(int j=0;j<n;j++) snake[p++]= i*n + (n-1-j) + 1;
        }
    }
    if(check_and_print(n, snake)) return 0;

    // 3) try column-major
    vector<int> colmaj(N);
    for(int j=0,p=0;j<n;j++){
        for(int i=0;i<n;i++) colmaj[p++] = i*n + j + 1;
    }
    if(check_and_print(n, colmaj)) return 0;

    // 4) try anti-diagonal filling: fill by anti-diagonals increasing
    vector<int> anti(N);
    int p = 0;
    for(int s = 0; s <= 2*(n-1); ++s){
        int start_i = max(0, s - (n-1));
        int end_i = min(n-1, s);
        for(int i = start_i; i <= end_i; ++i){
            int j = s - i;
            anti[p++] = i*n + j + 1;
        }
    }
    if(check_and_print(n, anti)) return 0;

    // 5) random attempts
    std::mt19937_64 rnd((uint64_t)chrono::high_resolution_clock::now().time_since_epoch().count());
    vector<int> cur = base;
    const int MAX_TRIES = 200;
    for(int it=0; it<MAX_TRIES; ++it){
        shuffle(cur.begin(), cur.end(), rnd);
        if(check_and_print(n, cur)) return 0;
    }

    // Extremely unlikely to reach here for n>=3, but fallback:
    cout << "No\n";
    return 0;
}
