#include <bits/stdc++.h>
using namespace std;
using int64 = long long;

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    if(!(cin >> n)) return 0;
    deque<pair<string,int64>> q;
    for(int i=0;i<n;i++){
        string name; int64 len;
        cin >> name >> len;
        q.emplace_back(name, len);
    }
    int m; cin >> m;
    struct Event { int64 t; string name; int64 len; };
    vector<Event> ev(m);
    for(int i=0;i<m;i++){
        cin >> ev[i].t >> ev[i].name >> ev[i].len;
    }

    int idx = 0; // next event index
    int64 cur = 0;
    vector<pair<string,int64>> ans;
    // main loop
    while(!q.empty() || idx < m){
        if(q.empty()){
            // idle until next event time, gather all events at that time
            cur = max(cur, ev[idx].t);
            while(idx < m && ev[idx].t == cur){
                q.emplace_front(ev[idx].name, ev[idx].len);
                idx++;
            }
            continue;
        }
        // start next song now
        auto song = q.front(); q.pop_front();
        string name = song.first;
        int64 len = song.second;
        ans.emplace_back(name, cur);
        int64 finish = cur + len;
        // process all events with t <= finish (including t == finish)
        while(idx < m && ev[idx].t <= finish){
            q.emplace_front(ev[idx].name, ev[idx].len);
            idx++;
        }
        // advance time to finish
        cur = finish;
    }

    // print answer
    for(auto &p : ans){
        cout << p.first << ' ' << p.second << '\n';
    }
    return 0;
}
