#include <bits/stdc++.h>
using namespace std;

struct Song {
    string name;
    long long len;
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    deque<Song> q;

    for (int i = 0; i < n; i++) {
        string name;
        long long len;
        cin >> name >> len;
        q.push_back({name, len});
    }

    int m;
    cin >> m;

    struct Event {
        long long t;
        string name;
        long long len;
    };

    vector<Event> ev(m);
    for (int i = 0; i < m; i++)
        cin >> ev[i].t >> ev[i].name >> ev[i].len;

    long long cur_time = 0;            // қазір әннің басталу уақыты
    int ptr = 0;                       // оқиғаларға көрсеткіш

    vector<pair<string,long long>> ans; // (name, start_time)

    while (!q.empty() || ptr < m) {

        // Егер кезекте ән бар болса, оның ұзақтығын аламыз
        long long finish_time = LLONG_MAX;

        if (!q.empty())
            finish_time = cur_time + q.front().len;

        long long next_event = (ptr < m ? ev[ptr].t : LLONG_MAX);

        if (next_event < finish_time) {
            // Оқиға ән біткенше болды → ән ойнап жатыр
            // Жай ғана жаңа әнді кезекке қосамыз
            q.push_back({ev[ptr].name, ev[ptr].len});
            ptr++;
        }
        else {
            // Немесе ән бітеді, немесе дәл бітетін сәтте оқиға бар

            // 1) Қазіргі әнді аяқтаймыз
            if (!q.empty()) {
                ans.push_back({q.front().name, cur_time});
                cur_time = finish_time;
                q.pop_front();
            }

            // 2) Егер дәл осы мезетте оқиғалар болса – бәрін қатар қосамыз
            while (ptr < m && ev[ptr].t == cur_time) {
                q.push_back({ev[ptr].name, ev[ptr].len});
                ptr++;
            }
        }
    }

    // Шығару
    for (auto &p : ans)
        cout << p.first << " " << p.second << "\n";

    return 0;
}
