#include <bits/stdc++.h>
using namespace std;

// Hopcroft-Karp for bipartite matching (left 0..L-1, right 0..R-1)
struct HopcroftKarp {
    int L, R;
    vector<vector<int>> g;
    vector<int> dist, pairU, pairV;

    HopcroftKarp(int L_, int R_): L(L_), R(R_), g(L_), dist(L_), pairU(L_, -1), pairV(R_, -1) {}

    void addEdge(int u, int v) { // u in [0..L-1], v in [0..R-1]
        g[u].push_back(v);
    }

    bool bfs() {
        queue<int>q;
        for (int u = 0; u < L; ++u) {
            if (pairU[u] == -1) {
                dist[u] = 0;
                q.push(u);
            } else dist[u] = -1;
        }
        bool reachableFree = false;
        while (!q.empty()) {
            int u = q.front(); q.pop();
            for (int v: g[u]) {
                int pu = pairV[v];
                if (pu != -1 && dist[pu] == -1) {
                    dist[pu] = dist[u] + 1;
                    q.push(pu);
                }
                if (pu == -1) reachableFree = true;
            }
        }
        return reachableFree;
    }

    bool dfs(int u) {
        for (int v: g[u]) {
            int pu = pairV[v];
            if (pu == -1 || (dist[pu] == dist[u] + 1 && dfs(pu))) {
                pairU[u] = v;
                pairV[v] = u;
                return true;
            }
        }
        dist[u] = -1;
        return false;
    }

    int maxMatching() {
        int result = 0;
        while (bfs()) {
            for (int u = 0; u < L; ++u) {
                if (pairU[u] == -1 && dfs(u)) result++;
            }
        }
        return result;
    }
};

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    if (!(cin >> n)) return 0;

    if (n == 2) {
        cout << -1 << '\n';
        return 0;
    }
    // allocate matrix 1-based indexing for convenience
    vector<vector<int>> a(n+1, vector<int>(n+1, 0));
    // used[col][sym] = whether symbol sym is already used in column col
    vector<vector<char>> used(n+1, vector<char>(n+1, 0));

    // place diagonal a[i][i] = i
    for (int i = 1; i <= n; ++i) {
        a[i][i] = i;
        used[i][i] = 1;
    }

    // fill rows one by one
    for (int r = 1; r <= n; ++r) {
        // columns list (exclude r)
        vector<int> cols;
        cols.reserve(n-1);
        for (int c = 1; c <= n; ++c) if (c != r) cols.push_back(c);
        int L = (int)cols.size(); // n-1
        // symbols list (exclude r)
        vector<int> syms;
        syms.reserve(n-1);
        vector<int> symIndex(n+1, -1);
        for (int s = 1; s <= n; ++s) if (s != r) {
            symIndex[s] = (int)syms.size();
            syms.push_back(s);
        }
        int R = (int)syms.size(); // n-1
        HopcroftKarp hk(L, R);
        // build edges: left u corresponds to column cols[u], right v corresponds to symbol syms[v]
        for (int u = 0; u < L; ++u) {
            int col = cols[u];
            for (int v = 0; v < R; ++v) {
                int sym = syms[v];
                if (!used[col][sym]) {
                    hk.addEdge(u, v);
                }
            }
        }
        int mm = hk.maxMatching();
        if (mm != L) {
            // Theoretically shouldn't happen for n != 2
            cout << -1 << '\n';
            return 0;
        }
        // fill row r using matching pairU[u] = v
        for (int u = 0; u < L; ++u) {
            int v = hk.pairU[u];
            int col = cols[u];
            int sym = syms[v];
            a[r][col] = sym;
            used[col][sym] = 1;
        }
        // note: a[r][r] already set to r and used[r][r] already true
    }

    // output
    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= n; ++j) {
            if (j > 1) cout << ' ';
            cout << a[i][j];
        }
        cout << '\n';
    }
    return 0;
}
