#include <bits/stdc++.h>
using namespace std;

struct HopcroftKarp {
    int nL, nR;
    vector<vector<int>> g;
    vector<int> pairU, pairV, dist;
    const int INF = 1e9;
    HopcroftKarp(int _nL=0,int _nR=0){ init(_nL,_nR); }
    void init(int _nL,int _nR){
        nL=_nL; nR=_nR;
        g.assign(nL, {});
        pairU.assign(nL, -1);
        pairV.assign(nR, -1);
        dist.assign(nL, 0);
    }
    void addEdge(int u,int v){ g[u].push_back(v); }
    bool bfs(){
        queue<int> q;
        for(int u=0;u<nL;++u){
            if(pairU[u]==-1){ dist[u]=0; q.push(u); }
            else dist[u]=INF;
        }
        bool reachableFree=false;
        while(!q.empty()){
            int u=q.front(); q.pop();
            for(int v: g[u]){
                int pu = pairV[v];
                if(pu!=-1 && dist[pu]==INF){
                    dist[pu]=dist[u]+1;
                    q.push(pu);
                }
                if(pu==-1) reachableFree=true;
            }
        }
        return reachableFree;
    }
    bool dfs(int u){
        for(int v: g[u]){
            int pu = pairV[v];
            if(pu==-1 || (dist[pu]==dist[u]+1 && dfs(pu))){
                pairU[u]=v;
                pairV[v]=u;
                return true;
            }
        }
        dist[u]=INF;
        return false;
    }
    int maxMatching(){
        fill(pairU.begin(), pairU.end(), -1);
        fill(pairV.begin(), pairV.end(), -1);
        int matching=0;
        while(bfs()){
            for(int u=0;u<nL;++u)
                if(pairU[u]==-1 && dfs(u))
                    ++matching;
        }
        return matching;
    }
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    if(!(cin >> n)) return 0;
    if(n==1){
        cout << "1\n";
        return 0;
    }
    if(n==2){
        cout << -1 << "\n";
        return 0;
    }

    // used[c][s] == true if symbol s already used in column c
    vector<vector<char>> used(n+1, vector<char>(n+1, 0));
    vector<vector<int>> A(n+1, vector<int>(n+1, 0)); // 1-based

    for(int i=1;i<=n;++i){
        // place A[i][i] = i
        if(used[i][i]){
            cout << -1 << "\n"; return 0;
        }
        A[i][i]=i;
        used[i][i]=1;

        // left: columns j != i
        vector<int> cols;
        cols.reserve(n-1);
        for(int j=1;j<=n;++j) if(j!=i) cols.push_back(j);
        // right: symbols s != i
        vector<int> syms;
        syms.reserve(n-1);
        for(int s=1;s<=n;++s) if(s!=i) syms.push_back(s);

        int L = (int)cols.size(), R = (int)syms.size();
        HopcroftKarp hk(L,R);
        for(int li=0; li<L; ++li){
            int c = cols[li];
            for(int ri=0; ri<R; ++ri){
                int s = syms[ri];
                if(!used[c][s]) hk.addEdge(li, ri);
            }
        }
        int matching = hk.maxMatching();
        if(matching < L){
            cout << -1 << "\n"; return 0;
        }
        for(int li=0; li<L; ++li){
            int ri = hk.pairU[li];
            int c = cols[li];
            int s = syms[ri];
            A[i][c] = s;
            used[c][s] = 1;
        }
    }

    // print matrix
    for(int i=1;i<=n;++i){
        for(int j=1;j<=n;++j){
            if(j>1) cout << ' ';
            cout << A[i][j];
        }
        cout << '\n';
    }
    return 0;
}
