#include <bits/stdc++.h>
using namespace std;
using int64 = long long;
const int64 MOD = 1000000007LL;

int64 modpow(int64 a, int64 e){
    int64 r = 1 % MOD;
    a %= MOD;
    while(e){
        if(e & 1) r = (r * a) % MOD;
        a = (a * a) % MOD;
        e >>= 1;
    }
    return r;
}
int64 invmod(int64 x){ return modpow((x%MOD+MOD)%MOD, MOD-2); }

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int T; 
    if(!(cin >> T)) return 0;
    while(T--){
        int n, m;
        long long l;
        cin >> n >> m >> l;
        struct Edge { int u,v; long long w; bool known; int id; };
        vector<Edge> edges;
        edges.reserve(m);
        for(int i=0;i<m;i++){
            int u,v; long long w; cin >> u >> v >> w;
            edges.push_back({u-1,v-1,w, w!=-1, i});
        }
        vector<long long> d(n);
        for(int i=0;i<n;i++) cin >> d[i];

        // basic checks
        if(d[0] != 0){
            cout << 0 << "\n"; continue;
        }
        bool bad=false;
        for(int i=1;i<n;i++) if(d[i]==0){ bad=true; break; }
        if(bad){ cout << 0 << "\n"; continue; }

        // We will create directed candidates u->v when d[u] < d[v] and diff in [1..l]
        // Track known tight edges and candidate unknown edges
        // For unknown edges compute R_e and p_e = R_e - 1 if candidate and >=1,
        // or p_e = R_e if non-candidate unknown

        // arrays
        vector<int64> R(m,0);
        vector<int> kind(m,0); // 0 unknown non-candidate, 1 candidate with p>=1, 2 candidate forced (R==1), 3 known tight, 4 known non-tight
        // We'll also collect incoming lists from lower layers
        vector<vector<int>> incoming_idx(n); // store edge idx that points into v in tight-graph (both known tight and candidate)
        // Also mark known-tight edges
        for(int i=0;i<m;i++){
            int u = edges[i].u, v = edges[i].v;
            long long du = d[u], dv = d[v];
            long long diff = llabs(du - dv);
            if(edges[i].known){
                long long w = edges[i].w;
                if(w < diff){ bad = true; break; } // triangle violation
                if(du < dv){
                    if(w == dv - du){
                        kind[i] = 3; // known tight u->v
                        incoming_idx[v].push_back(i);
                    } else {
                        kind[i] = 4; // known but not tight
                    }
                } else if(dv < du){
                    if(w == du - dv){
                        kind[i] = 3; // known tight v->u
                        incoming_idx[u].push_back(i);
                    } else {
                        kind[i] = 4;
                    }
                } else {
                    // du == dv, known weight >=0 (>=diff=0), but cannot be tight because tight would require 0 weight which is forbidden
                    kind[i] = 4;
                }
            } else {
                // unknown
                long long minx = max(1LL, diff);
                if(minx > l){ // no allowed values
                    bad = true; break;
                }
                R[i] = l - minx + 1; // total options
                if(du < dv){
                    long long t = dv - du;
                    if(1 <= t && t <= l){
                        // candidate: can be tight u->v when set to t
                        if(R[i] == 1){
                            kind[i] = 2; // forced tight
                            incoming_idx[v].push_back(i);
                        } else {
                            kind[i] = 1; // candidate with p>=1
                            incoming_idx[v].push_back(i);
                        }
                    } else {
                        // cannot be tight in direction u->v, it's non-candidate
                        kind[i] = 0;
                    }
                } else if(dv < du){
                    long long t = du - dv;
                    if(1 <= t && t <= l){
                        if(R[i] == 1){
                            kind[i] = 2;
                            incoming_idx[u].push_back(i);
                        } else {
                            kind[i] = 1;
                            incoming_idx[u].push_back(i);
                        }
                    } else {
                        kind[i] = 0;
                    }
                } else {
                    // du == dv : cannot be tight
                    kind[i] = 0;
                }
            }
        }
        if(bad){ cout << 0 << "\n"; continue; }

        // Build layers: unique sorted distances
        vector<long long> ds = d;
        sort(ds.begin(), ds.end());
        ds.erase(unique(ds.begin(), ds.end()), ds.end());
        // check that only d[0]==0 exists at first layer; we already ensured no other zero d
        // Prepare mapping vertex->layer index
        unordered_map<long long,int> layerIndex;
        for(int i=0;i<(int)ds.size();++i) layerIndex[ds[i]] = i;
        // For counting, we will process layers in increasing order; for a vertex v in layer >0, allowed parent edges must come from earlier layers
        // Need to ensure each vertex has at least one incoming tight-capable edge from previous layers (known tight or candidate or forced)
        bool impossible = false;
        for(int v=0; v<n; ++v){
            if(v==0) continue;
            // check incoming edges list includes at least one with source in earlier layer
            bool ok = false;
            for(int ei : incoming_idx[v]){
                int u = edges[ei].u, wv = edges[ei].v;
                int src = (edges[ei].u == v ? edges[ei].v : edges[ei].u); // not needed - we know incoming list is to v
                // We must find source index
            }
        }
        // We need to check incoming edges are from smaller d nodes; incoming_idx construction ensured the edge points into the higher d node.
        // Now check reachability possibility: each vertex v (except those in layer 0) must have at least one incoming edge recorded (from earlier layer)
        for(int v=0; v<n; ++v){
            if(d[v]==ds[0]){ // minimal layer
                if(v==0) continue; // only node1 allowed at minimal layer (checked earlier)
                // if there is any other vertex in minimal layer (same d), there are no incoming edges (since need du<dv), so impossible
                // But we already checked no other d==0; but if minimal d>0? then impossible because node1 must be minimal zero
            }
        }
        // Now compute base product and per-vertex S_v
        int64 base = 1;
        // For unknown edges:
        for(int i=0;i<m;i++){
            if(!edges[i].known){
                if(kind[i]==0){
                    // non-candidate unknown, contributes R[i]
                    base = (base * (R[i] % MOD)) % MOD;
                } else if(kind[i]==1){
                    // candidate with p>=1, contributes p_e = R[i]-1 to base
                    int64 p = (R[i] - 1) % MOD;
                    base = (base * p) % MOD;
                } else if(kind[i]==2){
                    // forced tight: contributes nothing to base (fixed), handled as incoming tight
                }
            }
        }

        // Prepare inverse p_e for candidate edges kind==1
        vector<int64> invp(m,0);
        for(int i=0;i<m;i++){
            if(kind[i]==1){
                int64 p = R[i]-1;
                invp[i] = invmod(p % MOD);
            }
        }

        int64 ans = base;
        bool zero = false;
        // process layers ascending; for vertices in first layer, only node1 must belong
        // We'll get list of vertices per layer
        vector<vector<int>> verts_by_layer(ds.size());
        for(int v=0; v<n; ++v) verts_by_layer[layerIndex[d[v]]].push_back(v);

        // Check that only vertex 0 is in minimal layer (d==0). Already checked earlier for zeros; but there could be other minimal d>0 if d[0] not minimal -> handled earlier.
        if(ds[0] != 0){ cout << 0 << "\n"; continue; }
        if(verts_by_layer[0].size() != 1 || verts_by_layer[0][0] != 0){
            // there is some other vertex with d==0 or node1 not unique in layer0 => impossible
            cout << 0 << "\n"; continue;
        }

        // For each subsequent layer:
        for(size_t li = 1; li < ds.size(); ++li){
            for(int v : verts_by_layer[li]){
                // compute S_v: sum over incoming edges (those in incoming_idx[v]) that originate from previous layers
                int64 Sv = 0;
                for(int ei : incoming_idx[v]){
                    // incoming_idx stores edges that can be tight into v
                    // find source u
                    int u = edges[ei].u, wv = edges[ei].v;
                    int src = (d[u] < d[wv]) ? u : ( (d[wv] < d[u]) ? wv : -1 );
                    // But incoming_idx[v] was filled such that edge is incoming into v (we pushed the index to v earlier)
                    // So source is the other endpoint of this edge
                    int from = edges[ei].u == v ? edges[ei].v : edges[ei].u;
                    // ensure from is in earlier layer
                    if(d[from] >= d[v]) continue; // shouldn't happen but safe
                    if(edges[ei].known){
                        // known tight
                        Sv = (Sv + 1) % MOD;
                    } else {
                        if(kind[ei] == 2){
                            // forced tight => contributes 1
                            Sv = (Sv + 1) % MOD;
                        } else if(kind[ei] == 1){
                            // candidate with p>=1 -> contributes inv(p_e)
                            Sv = (Sv + invp[ei]) % MOD;
                        } else {
                            // kind==0 (non-candidate unknown) cannot be incoming here
                        }
                    }
                }
                if(Sv == 0){
                    zero = true; break;
                }
                ans = (ans * Sv) % MOD;
            }
            if(zero) break;
        }
        if(zero) cout << 0 << "\n";
        else cout << ans % MOD << "\n";
    }
    return 0;
}
