import sys
input = sys.stdin.readline

# ======== SEGMENT TREE FOR RUNS OF ONES ========
class SegTree:
    def __init__(self, n):
        self.n = n
        self.size = 1
        while self.size < n:
            self.size <<= 1

        self.pref = [0]*(2*self.size)
        self.suff = [0]*(2*self.size)
        self.best = [0]*(2*self.size)
        self.len  = [0]*(2*self.size)

        for i in range(self.size, self.size + n):
            self.len[i] = 1
        for i in range(self.size+n, 2*self.size):
            self.len[i] = 1

        for i in range(self.size-1, 0, -1):
            self.len[i] = self.len[i*2] + self.len[i*2+1]

    def merge(self, i):
        L, R = 2*i, 2*i+1
        self.pref[i] = self.pref[L] if self.pref[L] < self.len[L] else self.len[L] + self.pref[R]
        self.suff[i] = self.suff[R] if self.suff[R] < self.len[R] else self.suff[L] + self.suff[R]
        self.best[i] = max(self.best[L], self.best[R], self.suff[L] + self.pref[R])

    def update(self, pos, val):
        i = pos + self.size
        self.pref[i] = self.suff[i] = self.best[i] = val
        i >>= 1
        while i:
            self.merge(i)
            i >>= 1

    # query longest run of ones in interval [l,r]
    def query(self, l, r):
        if l > r:
            return 0

        l += self.size
        r += self.size

        left_pref = left_suff = left_best = 0
        left_len = 0
        right_pref = right_suff = right_best = 0
        right_len = 0

        while l <= r:
            if l & 1:
                if left_len == 0:
                    left_pref = self.pref[l]
                    left_suff = self.suff[l]
                    left_best = self.best[l]
                    left_len = self.len[l]
                else:
                    new_pref = left_pref if left_pref < left_len else left_len + self.pref[l]
                    new_suff = self.suff[l] if self.suff[l] < self.len[l] else self.suff[l] + left_suff
                    new_best = max(left_best, self.best[l], left_suff + self.pref[l])
                    left_pref, left_suff, left_best = new_pref, new_suff, new_best
                    left_len += self.len[l]
                l += 1

            if not (r & 1):
                if right_len == 0:
                    right_pref = self.pref[r]
                    right_suff = self.suff[r]
                    right_best = self.best[r]
                    right_len = self.len[r]
                else:
                    new_pref = self.pref[r] if self.pref[r] < self.len[r] else self.len[r] + right_pref
                    new_suff = right_suff if right_suff < right_len else right_len + self.suff[r]
                    new_best = max(right_best, self.best[r], self.suff[r] + right_pref)
                    right_pref, right_suff, right_best = new_pref, new_suff, new_best
                    right_len += self.len[r]
                r -= 1

            l >>= 1
            r >>= 1

        if left_len == 0:  return right_best
        if right_len == 0: return left_best
        return max(left_best, right_best, left_suff + right_pref)


# ================== MAIN LOGIC =====================
n = int(input())
a = list(map(int, input().split()))

L = SegTree(n)
R = SegTree(n)

# Build initial L and R
for i in range(n):
    L.update(i, 1 if i+1 < n and a[i+1] == a[i] - 1 else 0)
    R.update(i, 1 if i-1 >= 0 and a[i-1] == a[i] - 1 else 0)


def center_len(c):
    left  = R.query(c, n-1)
    right = L.query(c, n-1)
    return 2 * min(left, right) + 1


def get_global():
    ans = 1
    for c in range(n):
        ans = max(ans, center_len(c))
    return ans


# initial answer
print(get_global())

q = int(input())
for _ in range(q):
    i, x = map(int, input().split())
    i -= 1
    a[i] = x

    # update affected L/R entries
    if i > 0:
        R.update(i, 1 if a[i-1] == a[i] - 1 else 0)
    else:
        R.update(i, 0)

    if i < n-1:
        L.update(i, 1 if a[i+1] == a[i] - 1 else 0)
    else:
        L.update(i, 0)

    if i > 0:
        L.update(i-1, 1 if a[i] == a[i-1] - 1 else 0)
    if i < n-1:
        R.update(i+1, 1 if a[i] == a[i+1] - 1 else 0)

    print(get_global())
