from collections import deque
import sys
input = sys.stdin.read

data = input().splitlines()
n = int(data[0])
queue = deque()
for i in range(1, n+1):
    name, length = data[i].split()
    queue.append((name, int(length)))

m = int(data[n+1])
events = []
for i in range(n+2, n+2+m):
    t, name, length = data[i].split()
    events.append((int(t), name, int(length)))

res = []
current_time = 0
event_idx = 0

while queue or event_idx < m:
    if queue:
        name, length = queue.popleft()
        # проверяем, есть ли события, которые добавляются раньше окончания песни
        while event_idx < m and events[event_idx][0] < current_time + length:
            t, ename, elen = events[event_idx]
            queue.appendleft((ename, elen))
            event_idx += 1
        # песня начинает играть в current_time
        res.append((name, current_time))
        current_time += length
    else:
        # если очередь пуста, но есть события в будущем
        t, ename, elen = events[event_idx]
        current_time = max(current_time, t)
        queue.appendleft((ename, elen))
        event_idx += 1

for name, start in res:
    print(name, start)
