#include <bits/stdc++.h>
using namespace std;

static const long long MOD = 998244353;

long long addmod(long long a, long long b){
    a += b;
    if(a >= MOD) a -= MOD;
    return a;
}
long long mulmod(long long a, long long b){
    return (a % MOD) * (b % MOD) % MOD;
}

// sum of numbers L..R
long long sum1(long long L, long long R){
    long long cnt = (R - L + 1) % MOD;
    long long s = (L + R) % MOD;
    return mulmod(cnt, s) * ((MOD + 1) / 2) % MOD;
}

// sum of squares L..R
long long sum2(long long L, long long R){
    auto f = [&](long long x){
        long long a = x % MOD;
        long long b = (a + 1) % MOD;
        long long c = (2*a + 1) % MOD;
        long long res = mulmod(a, mulmod(b, c));
        return mulmod(res, (MOD + 1) / 6);
    };
    return (f(R) - f(L-1) + MOD) % MOD;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    long long n;
    cin >> n;

    long long ans = 0;

    long long j = 1;
    while(j <= n){
        long long q = n / j;
        long long r = n / q;

        // sum_j(j*(j-1)/2) over j..r
        long long S1 = sum1(j, r);      // sum j
        long long S2 = sum2(j, r);      // sum j^2

        long long term1 = (S2 - S1 + MOD) % MOD;   // sum(j*(j-1))
        term1 = mulmod(term1, (MOD + 1) / 2);      // divide by 2
        term1 = mulmod(term1, q);                  // *q

        // second part: sum of rem*(rem+1)/2
        long long term2 = 0;
        for(long long jj = j; jj <= r; ++jj){
            long long rem = n % jj;
            long long tmp = mulmod(rem, rem + 1);
            tmp = mulmod(tmp, (MOD + 1) / 2);
            term2 = addmod(term2, tmp);
        }

        ans = addmod(ans, addmod(term1, term2));
        j = r + 1;
    }

    cout << ans % MOD;
}
