﻿#define _CRT_SECURE_NO_WARNINGS
#include <iostream>
#include <set>
#include <map>
#include <numeric>
#include <algorithm>
#include <functional>
#include <unordered_set>
#include <unordered_map>
#include <deque>
#include <queue>
#include <cmath>
#include <string>
#include <array>
#include <tuple>
#include <iomanip>
#include <ctime>
#include <chrono>
#define all(x) x.begin(), x.end()
#define endl '\n'


using namespace std;


const int INF = 1e9;
const int MOD = 1e9 + 7;
using ll = long long;
using db = long double;
const ll LINF = 1LL << 61;
const db EPS = 1e-7;
//#define int ll


struct Point {
	db x, y;
	Point(db x, db y) : x(x), y(y) {};
	Point(const Point& p1, const Point& p2) : x(p2.x - p1.x), y(p2.y - p1.y) {};
	static Point ByPolar(db len, db ang) {
		return { len * cos(ang), len * sin(ang) };
	}

	db len() {
		return hypot(x, y);
	}
	Point inverse() {
		return { -x, -y };
	}
	Point orthogonal() {
		return { -y, x };
	}
	Point operator*(const Point& p) {
		return { this->x * p.x, this->y * p.y };
	}
	Point operator+(const Point& p) {
		return { this->x + p.x, this->y + p.y };
	}
	db dotproduct(const Point &p) {
		return x * p.x + y * p.y;
	}
	db crossproduct(const Point& p) {
		return this->x * p.y - this->y * p.x;
	}
};

template <typename T>
struct segment_tree {
	int n;
	vector<T> tree;

	segment_tree(vector <int> &vec) {
		int n = vec.size();
		tree.resize(n, 0);

	}
};


ll binpow(int n, int st, int mod) {
	if (st == 0) return 1;
	if (st % 2 == 0) {
		ll f = binpow(n, st / 2, mod);
		return f * f;
	}
	return n * binpow(n, st - 1, mod);
}


db ternarnik3(db s, db e, Point v12, db R, Point p1) {

	db l = s, r = e;
	while (r - l > EPS) {

		db m1 = l + (l + r) / 3.;
		db m2 = r - (l + r) / 3.;
		Point p3_1 = Point::ByPolar(R, m1);
		Point p3_2 = Point::ByPolar(R, m2);

		Point v13_1(p1, p3_1);
		Point v13_2(p1, p3_2);
		if (abs(v12.crossproduct(v13_1)) - abs(v12.crossproduct(v13_2)) > EPS) {
			r = m2;
		}
		else {
			l = m1;
		}
	}
	return l;
}


pair<db, db> ternarnik2(db s, db e, db R, Point p1, db s3, db e3) {

	db r = e, l = s;
	while (r - l > EPS) {

		db m1_2 = l + (l + r) / 3.;
		Point p2 = Point::ByPolar(R, m1_2);
		Point v12(p1, p2);


		Point p3_1 = Point::ByPolar(r, ternarnik3(s3, e3, v12, r, p1));
		db S1_2 = abs(v12.crossproduct(Point(p1, p3_1)));


		db m2_2 = r - (l + r) / 3.;
		p2 = Point::ByPolar(R, m2_2);
		v12 = Point(p1, p2);


		Point p3_2 = Point::ByPolar(r, ternarnik3(s3, e3, v12, r, p1));
		db S2_2 = abs(v12.crossproduct(Point(p1, p3_2)));

		if (S1_2 - S2_2 < EPS) {
			l = m1_2;
		}
		else {
			r = m2_2;
		}
	}
	Point p2 = Point::ByPolar(R, r);
	Point v12(p1, p2);
	return { l, ternarnik3(s3, e3, v12, R, p1) };
}


void solve() {
	int n;
	cin >> n;
	if (n == 1 || n == 2) {
		cout << "No" << endl;
		return;
	}
	vector<vector<int>> m(n, vector<int>(n, -1));
	int ch = n * n;
	for (int i = 0; i < n; i++) {
		m[n - 1][i] = ch;
		ch--;
	}
	for (int j = n - 2; j >= 0; j--) {
		m[j][n / 2] = ch;
		ch--;
	}
	for (int i = 0; i < n; i++) {
		for (int j = 0; j < n; j++) {
			if (m[i][j] == -1) {
				m[i][j] = ch;
				ch--;
			}
		}
	}
	cout << "Yes" << endl;
	for (auto& i : m) {
		for (auto& j : i) {
			cout << j << " ";
		}
		cout << endl;
	}

}

signed main() {
	ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);
	cout.setf(ios::fixed); cout.precision(8);
	solve();
	
}