﻿#define _CRT_SECURE_NO_WARNINGS
#include <iostream>
#include <set>
#include <map>
#include <numeric>
#include <algorithm>
#include <functional>
#include <unordered_set>
#include <unordered_map>
#include <deque>
#include <queue>
#include <cmath>
#include <string>
#include <array>
#include <tuple>
#include <iomanip>
#include <ctime>
#include <chrono>
#define all(x) x.begin(), x.end()
#define endl '\n'


using namespace std;


const int INF = 1e9;
const int MOD = 1e9 + 7;
using ll = long long;
using db = long double;
const ll LINF = 1LL << 61;
//#define int ll


struct Point {
	db x, y;
	Point(db x, db y) : x(x), y(y) {};
	static Point ByPolar(db len, db ang) {
		return { len * cos(ang), len * sin(ang) };
	}

	db len() {
		return hypot(x, y);
	}
	Point inverse() {
		return { -x, -y };
	}
	Point orthogonal() {
		return { -y, x };
	}
	Point operator*(const Point& p) {
		return { this->x * p.x, this->y * p.y };
	}
	Point operator+(const Point& p) {
		return { this->x + p.x, this->y + p.y };
	}
	db dotproduct(const Point &p) {
		return x * p.x + y * p.y;
	}
	db crossproduct(const Point& p) {
		return x * p.y - y * p.x;
	}
};

template <typename T>
struct segment_tree {
	int n;
	vector<T> tree;

	segment_tree(vector <int> &vec) {
		int n = vec.size();
		tree.resize(n, 0);

	}
};


ll binpow(int n, int st, int mod) {
	if (st == 0) return 1;
	if (st % 2 == 0) {
		ll f = binpow(n, st / 2, mod);
		return f * f;
	}
	return n * binpow(n, st - 1, mod);
}


void solve() {
	
	int n, l;
	cin >> n >> l;
	l = abs(l);

	vector <pair<int, int>> vec(n, {0, 0});
	for (int i = 0; i < n; i++) {
		int a; cin >> a;
		vec[i].second = a;
	}
	for (int i = 0; i < n; i++) {
		int a; cin >> a;
		vec[i].first = a;
	}
	sort(all(vec));

	vector <pair<ll, unordered_set<int>>> dp(6001, { LINF, {} });
	dp[0] = { 0, {} };
	queue <int> q;
	q.push(0);

	while (q.size()) {
		int i = q.front(); q.pop();

		for (int j = 0; j < n; j++) {
			int add = 0;
			if (dp[i].second.find(j) == dp[i].second.end()) {
				add = vec[j].first;
			}
			int x = vec[j].second;
			if (i + x < dp.size() && dp[i + x].first > dp[i].first + add) {
				dp[i + x] = dp[i];
				dp[i + x].second.insert(j);
				dp[i + x].first += add;
				q.push(i + x);
			}
			if (i - x >= 0 && dp[i - x].first > dp[i].first + add) {
				dp[i - x] = dp[i];
				dp[i - x].second.insert(j);
				dp[i - x].first += add;
				q.push(i - x);
			}
		}
	}
	if (dp[l].first == LINF) {
		cout << -1 << endl;
	}
	else {
		cout << dp[l].first << endl;
	}
}

signed main() {
	ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);
	cout.setf(ios::fixed); cout.precision(8);
	int tt;
	cin >> tt;
	while(tt--)
	solve();
	
}