#include <iostream>
#include <algorithm>
#include <cmath>
#include <string>
#include <iomanip>
#include <map>
#include <set>
#include <vector>
#include <unordered_map>
#include <unordered_set>
#include <cassert>

#pragma GCC target("avx2")

using namespace std;
using ll = long long;
using ld = double;
using ull = unsigned long long;
using uint = unsigned int;

constexpr ll inf = 1e18;
constexpr ld EPS = 1e-7;

const int T = 50;

ll rad;
ld l1, r1, l2, r2, l3, r3;

ld f2(ld al1, ld al2, ld al3) {
	ld x1 = cos(al1) * rad, y1 = sin(al1) * rad;
	ld x2 = cos(al2) * rad, y2 = sin(al2) * rad;
	ld x3 = cos(al3) * rad, y3 = sin(al3) * rad;
	ld s = fabs((x2 - x1) * (y3 - y1) - (x3 - x1) * (y2 - y1)) / 2;
	return s;
}

ld f1(ld al1, ld al2) {
	ld l = l3 - EPS, r = r2 + EPS;
	for (ll ind = 0; ind < T; ++ind) {
		ld m1 = l + (r - l) / 3, m2 = r - (r - l) / 3;
		if (f2(al1, al2, m1) < f2(al1, al2, m2)) {
			l = m1;
		}
		else {
			r = m2;
		}
	}
	return f2(al1, al2, (l + r) / 2);
}

ld f(ld al1) {
	ld l = l2 - EPS, r = r2 + EPS;
	for (ll ind = 0; ind < T; ++ind) {
		ld m1 = l + (r - l) / 3, m2 = r - (r - l) / 3;
		if (f1(al1, m1) < f1(al1, m2)) {
			l = m1;
		}
		else {
			r = m2;
		}
	}
	return f1(al1, (l + r) / 2);
}

void solve() {
	cin >> rad >> l1 >> r1 >> l2 >> r2 >> l3 >> r3;
	ld l = l1 - EPS, r = r1 + EPS;
	for (ll ind = 0; ind < T; ++ind) {
		ld m1 = l + (r - l) / 3, m2 = r - (r - l) / 3;
		if (f(m1) < f(m2)) {
			l = m1;
		}
		else {
			r = m2;
		}
	}
	cout << setprecision(10) << fixed;
	cout << f((l + r) / 2);
}

signed main() {
	ios::sync_with_stdio(false);
	cin.tie(nullptr);
	ll tt = 1;
	//cin >> tt;
	while (tt--) solve();
	return 0;
}