#include <bits/stdc++.h>

using namespace std;

using i64 = long long;

const i64 inf = 1e16;

const int N = 3001;

int g[N][N];

int get(int x, int y){
	if ( x > y ) swap(x, y);
	
	if ( !x ) return y;
	
	if ( g[x][y] ) return g[x][y];
	
	return g[x][y] = get(x, y - x);
}

void solve(){
	int n, L; cin >> n >> L;
	
	L = abs(L);
	
	vector <int> x(n), c(n);
	
	for ( auto &u: x ) cin >> u;
	for ( auto &v: c ) cin >> v;
	
	vector <i64> dp(N, inf);
	
	dp[0] = 0;
	
	for ( int i = 0; i < n; i++ ){
		auto nxt = dp;
		
		for ( int j = 0; j < N; j++ ){
			int t = get(j, x[i]);
			
			nxt[t] = min(nxt[t], dp[j] + c[i]);
		}
		
		swap(dp, nxt);
	}
	
	i64 opt = inf;
	
	for ( int y = 1; y <= L; y++ ){
		if ( L % y == 0 ) opt = min(opt, dp[y]);
	}
	
	if ( opt == inf ) opt = -1;
	
	cout << opt << '\n';
}

signed main(){
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);
	
	int t; cin >> t;
	
	while ( t-- ) solve();
}
