#include <bits/stdc++.h>
#include <experimental/random>
#include <ext/pb_ds/assoc_container.hpp>

using namespace std;
using namespace __gnu_pbds;
using ll = long long;
using ld = long double;
using ordered_set = tree<ll, null_type, less<ll>, rb_tree_tag, tree_order_statistics_node_update>;
constexpr ll INF = 1e18;
constexpr ll inf = 1e9;

mt19937 rnd(time(nullptr));

ll rand(ll n) {
    return rnd() % n;
}

//[]
ll rand(ll l, ll r) {
    return rand(r - l + 1);
}

void solve();

signed main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
#endif
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr), cout.tie(nullptr);
    ll t = 1;
    //cin >> t;
    while (t--) {
        solve();
    }
}

struct SegmentTree {
    int ans;
    int sz;

    int pref_up;
    int pref_down;
    int suf_up;
    int suf_down;

    int pref_up0;
    int pref_down0;
    int suf_up0;
    int suf_down0;
};

int n;
vector<int> a;
vector<SegmentTree> t;


SegmentTree Merge(SegmentTree l, SegmentTree r) {
    SegmentTree res;
    res.sz = l.sz + r.sz;
    res.ans = max({l.ans, r.ans});

    res.pref_up = l.pref_up;
    res.pref_up0 = l.pref_up0;
    res.pref_down = l.pref_down;
    res.pref_down0 = l.pref_down0;

    res.suf_up = r.suf_up;
    res.suf_up0 = r.suf_up0;
    res.suf_down = r.suf_down;
    res.suf_down0 = r.suf_down0;

    int last = l.suf_up+l.suf_up0-1;
    int first = r.pref_down0;
    if (abs(first-last) == 1 && l.sz + r.sz >= 3) {
        int begin = max(l.suf_up0, r.pref_down0-r.pref_down+1);
        res.ans = max(res.ans, (min(first, last)-begin+1)*2+1);
    }

    if (r.suf_up == r.sz) {
        if (r.suf_up0-1 == l.suf_up+l.suf_up0-1) {
            res.suf_up0 = l.suf_up0;
            res.suf_up = r.suf_up + l.suf_up;
        }
    }

    if (r.suf_down == r.sz) {
        if (r.suf_down0+1 == -l.suf_down+l.suf_down0+1) {
            res.suf_down0 = l.suf_down0;
            res.suf_down = l.suf_down + r.suf_down;
        }
    }

    if (l.pref_up == l.sz) {
        if (l.pref_up+l.pref_up0-1+1 == r.pref_up0) {
            res.pref_up = l.pref_up + r.pref_up;
            res.pref_up0 = l.pref_up0;
        }
    }
    if (l.pref_down == l.sz) {
        if (-l.pref_down+l.pref_down0+1-1 == r.pref_down0) {
            res.pref_down = l.pref_down + r.pref_down;
            res.pref_down0 = l.pref_down0;
        }
    }

    return res;
}

void build(int v, int l, int r) {
    if (r - l == 1) {
        t[v] = {1, 1, 1, 1, 1, 1, a[l], a[l], a[l], a[l]};
        return;
    }
    int mid = (l + r) / 2;
    build(2 * v + 1, l, mid);
    build(2 * v + 2, mid, r);
    t[v] = Merge(t[2 * v + 1], t[2 * v + 2]);
}

void upd(int v, int l, int r, int i) {
    if (r - l == 1) {
        t[v] = {1, 1, 1, 1, 1, 1, a[l], a[l], a[l], a[l]};
        return;
    }
    int mid = (l + r) / 2;
    if (i < mid) {
        upd(2 * v + 1, l, mid, i);
    } else {
        upd(2 * v + 2, mid, r, i);
    }
    t[v] = Merge(t[2 * v + 1], t[2 * v + 2]);
}

void solve() {
    cin >> n;
    a.resize(n);
    t.resize(4*n);
    for (int i = 0; i < n; ++i) {
        cin >> a[i];
    }
    build(0, 0, n);
    cout << t[0].ans << '\n';

    int q;
    cin >> q;
    while (q--) {
        int i, x;
        cin >> i >> x;
        i--;
        a[i] = x;
        upd(0, 0, n, i);
        cout << t[0].ans << '\n';
    }
}
