#include <iostream>
#include <vector>
#include <algorithm>
#include <cassert>
#include <string>
#include <deque>
#include <set>
#include <map>

using namespace std;
using ll = long long;
using ull = unsigned long long;
using ld = long double;

const int INF = 1e9 + 7;
const ll LL_INF = 4e18;

ostream& operator << (ostream& out, const vector<ll>& a) {
	for (const ll el : a) out << el << ' ';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<ll>>& a) {
	for (const vector<ll>& x : a) out << x << '\n';
	return out;
}
ostream& operator << (ostream& out, const vector<pair<ll,ll>>& a) {
	for (const pair<ll,ll>& x : a) out << x.first << ' ' << x.second << '|';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<pair<ll,ll>>>& a) {
	for (const vector<pair<ll,ll>>& x : a) out << x << '\n';
	return out;
}

ostream& operator << (ostream& out, const vector<int>& a) {
	for (const int el : a) out << el << ' ';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<int>>& a) {
	for (const vector<int>& x : a) out << x << '\n';
	return out;
}
ostream& operator << (ostream& out, const vector<pair<int, int>>& a) {
	for (const pair<int, int>& x : a) out << x.first << ' ' << x.second << '|';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<pair<int, int>>>& a) {
	for (const vector<pair<int, int>>& x : a) out << x << '\n';
	return out;
}

void solve() {
	int n;
	cin >> n;

	map<int, int> cnt;

	vector<int> arr(n);
	for (int i = 0; i < n; ++i) {
		cin >> arr[i];
		cnt[arr[i]]++;
	}

	for (const auto p : cnt) {
		if (p.second & 1) {
			cout << p.first << '\n';
			return;
		}
	}

	cout << -1 << '\n';
}

int main() {
	ios_base::sync_with_stdio(false); cin.tie(nullptr); cout.tie(nullptr);
	int TC;
	cin >> TC;
	//TC = 1;

	while (TC--) {
		solve();
	}


	return 0;
}