#include <iostream>
#include <vector>
#include <algorithm>
#include <cassert>
#include <string>

using namespace std;
using ll = long long;
using ull = unsigned long long;
using ld = long double;

const int INF = 1e9 + 7;
const ll LL_INF = 4e18;

ostream& operator << (ostream& out, const vector<ll>& a) {
	for (const ll el : a) out << el << ' ';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<ll>>& a) {
	for (const vector<ll>& x : a) out << x << '\n';
	return out;
}
ostream& operator << (ostream& out, const vector<pair<ll,ll>>& a) {
	for (const pair<ll,ll>& x : a) out << x.first << ' ' << x.second << '|';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<pair<ll,ll>>>& a) {
	for (const vector<pair<ll,ll>>& x : a) out << x << '\n';
	return out;
}

ostream& operator << (ostream& out, const vector<int>& a) {
	for (const int el : a) out << el << ' ';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<int>>& a) {
	for (const vector<int>& x : a) out << x << '\n';
	return out;
}
ostream& operator << (ostream& out, const vector<pair<int, int>>& a) {
	for (const pair<int, int>& x : a) out << x.first << ' ' << x.second << '|';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<pair<int, int>>>& a) {
	for (const vector<pair<int, int>>& x : a) out << x << '\n';
	return out;
}

struct Track {
	string name;
	ll len;
	ll add;
	bool extra = false;
	int id;
};

void solve() {
	int nst, nadd;
	cin >> nst;

	ll past = 0;
	ll accum = 0;
	vector<Track> arr(nst);

	for (int i = 0; i < nst; ++i) {
		cin >> arr[i].name >> arr[i].len;
		arr[i].add = accum;
		accum += arr[i].len;
		arr[i].extra = false;
		arr[i].id = i;
	}

	cin >> nadd;
	Track cur;

	vector<Track> t2(nadd);
	for (int i = 0; i < nadd; ++i) {
		cin >> t2[i].add >> t2[i].name >> t2[i].len;
	}

	int lb = 0;
	vector<Track> st;

	for (int i = 0; i < nst; ++i) {
		//cout << i << ' ' << lb << ' ' << t2[lb].add << ' ' << arr[i].add << '\n';
		while (lb < nadd && t2[lb].add <= past) {
			while (lb < nadd && t2[lb].add <= past) {
				st.push_back(t2[lb++]);
			}
			while (!st.empty()) {
				cout << st.back().name << ' ' << max(st.back().add, past) << '\n';
				past = max(st.back().add, past);
				past += st.back().len;
				st.pop_back();
			}
		}
		cout << arr[i].name << ' ' << max(arr[i].add, past) << '\n';
		past += arr[i].len;
	}

	while (lb < nadd) {
		cout << t2[lb].name << ' ' << max(past, t2[lb].add) << '\n';
		past = max(past, t2[lb].add);
		past += t2[lb++].len;
	}
}

int main() {
	ios_base::sync_with_stdio(false); cin.tie(nullptr); cout.tie(nullptr);
	int TC;
	//cin >> TC;
	TC = 1;

	while (TC--) {
		solve();
	}


	return 0;
}