#include <iostream>
#include <vector>
#include <algorithm>
#include <cassert>
#include <string>
#include <deque>
#include <set>
#include <map>

using namespace std;
using ll = long long;
using ull = unsigned long long;
using ld = long double;

const int INF = 1e9 + 7;
const ll LL_INF = 4e18;

ostream& operator << (ostream& out, const vector<ll>& a) {
	for (const ll el : a) out << el << ' ';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<ll>>& a) {
	for (const vector<ll>& x : a) out << x << '\n';
	return out;
}
ostream& operator << (ostream& out, const vector<pair<ll,ll>>& a) {
	for (const pair<ll,ll>& x : a) out << x.first << ' ' << x.second << '|';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<pair<ll,ll>>>& a) {
	for (const vector<pair<ll,ll>>& x : a) out << x << '\n';
	return out;
}

ostream& operator << (ostream& out, const vector<int>& a) {
	for (const int el : a) out << el << ' ';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<int>>& a) {
	for (const vector<int>& x : a) out << x << '\n';
	return out;
}
ostream& operator << (ostream& out, const vector<pair<int, int>>& a) {
	for (const pair<int, int>& x : a) out << x.first << ' ' << x.second << '|';
	return out;
}
ostream& operator << (ostream& out, const vector<vector<pair<int, int>>>& a) {
	for (const vector<pair<int, int>>& x : a) out << x << '\n';
	return out;
}

struct song {
	string name;
	ll l;
};

void solve() {
	ll n, m, t=0, ind_str=1, x, y;
	string s;
	
	deque<song> d;
	deque<pair<song, ll>> q;
	vector<song> ans;

	cin >> n;

	for (int i = 0; i < n; i++) {
		cin >> s >> x;
		d.push_back({ s, x });
	}

	cin >> m;

	for (int i = 0; i < m; i++) {
		cin >> x >> s >> y;
		q.push_back({ {s,y},x });
	}
	
	while (!d.empty() or !q.empty()) {
		while (!q.empty() and q.front().second <= t) {
			d.push_front({ q.front().first });
			q.pop_front();
		}

		if (!d.empty()) {
			int time = d.front().l;
			ans.push_back({ d.front().name, t });
			d.pop_front();
			t += time;
		}

		if (d.empty() and !q.empty()) {
			t = max(q.front().second, t);
			d.push_front(q.front().first);
			q.pop_front();
		}
	}
	for (auto x : ans) {
		cout << x.name << ' ' << x.l<< '\n';
	}
}

int main() {
	ios_base::sync_with_stdio(false); cin.tie(nullptr); cout.tie(nullptr);
	int TC=1;
	//cin >> TC;
	//TC = 1;

	while (TC--) {
		solve();
	}


	return 0;
}