import math

def triangle_area(r, a1, a2, b1, b2, c1, c2):
    def chord_length(angle1, angle2):
        return 2 * r * math.sin(abs(angle1 - angle2) / 2)
    
    def triangle_area_from_angles(angles):
        a, b, c = angles
        side_ab = chord_length(a, b)
        side_bc = chord_length(b, c)
        side_ca = chord_length(c, a)
        
        s = (side_ab + side_bc + side_ca) / 2
        return math.sqrt(s * (s - side_ab) * (s - side_bc) * (s - side_ca))
    
    num_samples = 100 
    
    max_area = 0.0
    arc_a_samples = [a1 + (a2 - a1) * i / (num_samples - 1) for i in range(num_samples)]
    arc_b_samples = [b1 + (b2 - b1) * i / (num_samples - 1) for i in range(num_samples)]
    arc_c_samples = [c1 + (c2 - c1) * i / (num_samples - 1) for i in range(num_samples)]
    
    for angle_a in arc_a_samples:
        for angle_b in arc_b_samples:
            for angle_c in arc_c_samples:
                area = triangle_area_from_angles([angle_a, angle_b, angle_c])
                if area > max_area:
                    max_area = area
    
    return max_area

r = float(input())
a1, a2, b1, b2, c1, c2 = map(float, input().split())

result = triangle_area(r, a1, a2, b1, b2, c1, c2)
print(f"{result:.10f}")