import math

# Чтение входных данных
r = float(input())
angles = list(map(float, input().split()))
a1, a2, b1, b2, c1, c2 = angles

# Количество точек для дискретизации каждой дуги
n = 100

# Генерация списков углов для каждой дуги
theta1_list = [a1 + i * (a2 - a1) / (n - 1) for i in range(n)]
theta2_list = [b1 + i * (b2 - b1) / (n - 1) for i in range(n)]
theta3_list = [c1 + i * (c2 - c1) / (n - 1) for i in range(n)]

max_area = 0.0

# Перебор всех комбинаций
for theta1 in theta1_list:
    for theta2 in theta2_list:
        for theta3 in theta3_list:
            diff1 = theta2 - theta1
            diff2 = theta3 - theta2
            diff3 = theta1 - theta3
            sum_sin = math.sin(diff1) + math.sin(diff2) + math.sin(diff3)
            area = 0.5 * r * r * abs(sum_sin)
            if area > max_area:
                max_area = area

# Вывод результата с высокой точностью
print(f"{max_area:.10f}")
