from collections import deque

def solve_playlist():
    # Read initial playlist
    n = int(input())
    playlist = deque()
    
    for _ in range(n):
        name, length = input().split()
        playlist.append((name, int(length)))
    
    # Read events
    m = int(input())
    events = []
    for _ in range(m):
        time, name, length = input().split()
        events.append((int(time), name, int(length)))
    
    # Process songs and events
    current_time = 0
    event_idx = 0
    results = []
    
    while playlist or event_idx < len(events):
        # Process any events that should happen at current_time or earlier
        while event_idx < len(events) and events[event_idx][0] <= current_time:
            time, name, length = events[event_idx]
            playlist.appendleft((name, length))
            event_idx += 1
        
        # If playlist is empty but there are future events, jump to next event time
        if not playlist and event_idx < len(events):
            current_time = events[event_idx][0]
            continue
        
        # If no songs and no more events, we're done
        if not playlist:
            break
        
        # Play the next song
        name, length = playlist.popleft()
        results.append((name, current_time))
        current_time += length
    
    # Output results
    for name, start_time in results:
        print(f"{name} {start_time}")

if __name__ == "__main__":
    solve_playlist()