import sys
import heapq
from collections import deque

def main():
    input_data = sys.stdin.read().splitlines()
    idx = 0
    
    # количество песен в начале
    n = int(input_data[idx]); idx += 1
    
    queue = deque()
    for _ in range(n):
        name, length = input_data[idx].split()
        idx += 1
        queue.append((name, int(length)))
    
    # количество событий
    m = int(input_data[idx]); idx += 1
    
    events = []
    for _ in range(m):
        t, name, length = input_data[idx].split()
        idx += 1
        events.append((int(t), name, int(length)))
    
    # текущая песня
    current_time = 0
    event_idx = 0
    
    while queue:
        name, length = queue.popleft()
        print(name, current_time)
        
        end_time = current_time + length
        
        # пока есть события, которые происходят до конца текущей песни
        while event_idx < m and events[event_idx][0] <= end_time:
            t, ename, elen = events[event_idx]
            event_idx += 1
            # если событие произошло ровно в момент окончания песни
            if t == end_time:
                queue.appendleft((ename, elen))
            else:
                queue.appendleft((ename, elen))
        current_time = end_time
    
    # если остались события после окончания всех песен
    while event_idx < m:
        t, ename, elen = events[event_idx]
        event_idx += 1
        queue.append((ename, elen))
    
    while queue:
        name, length = queue.popleft()
        print(name, current_time)
        current_time += length

if __name__ == "__main__":
    main()
