import math
from math import gcd

def gcd (a,b):
    while b:
        a,b = b, a%b
    return a
    
def is_prime_small(n):
    if n<2:
        return False
    if n == 2:
        return True
    if n%2==0:
        return False
    i=3
    while i*i <= n:
        if n%i==0:
            return False
        i=i+2
    return True
    
gc = {}

def compute_gs(x):
    if x in gc:
        return gc[x]
    if x<=3:
        gc[x]=0
        return 0
        
    reachable = set()
    has_move = False
    
    for a in range (2,x-1):
        b=x-a
        if gcd(a,b) > 1:
            has_move = True
            ga = compute_gs(a) if a<=100 else grundy_large(a)
            gb = compute_gs(b) if b<=100 else grundy_large(b)
            reachable.add(ga^gb)
            
    if not has_move:
        gc[x] = 0
        return 0
        
    mex = 0
    while mex in reachable:
        mex = mex + 1
    
    gc[x]=mex
    return mex
    
def grundy_large(x):
    if x == 4:
        return 0
        
    if x %2 != 0:
        is_prime= True
        for p in [3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59]:
            if x == p:
                return 0
            if x % p == 0:
                is_prime=False
                break
        
        if is_prime and x<10000:
            i = 53
            while i * i <= x:
                if x%i == 0:
                    is_prime = False
                    break
                i= i + 2
        if is_prime:
            return 0
        else:
            return 1
            
    return 1
    
def grundy(x):
    if x <= 100:
        return compute_gs(x)
    return grundy_large(x)
    
def solve_game(threads):
    xor_sum=0
    for length in threads:
        xor_sum ^= grundy(length)
    return xor_sum !=0
    
def main():
    t= int(input())
    
    for _ in range (t):
        n = int(input())
        threads = list(map(int, input().split()))
        
        if solve_game(threads):
            print("Yes")
        else:
            print ("No")
main()
