def gcd(a, b):
    a = abs(a)
    b = abs(b)
    while b:
        a, b = b, a % b
    return a

def lcm(a, b):
    if a == 0 or b == 0:
        return 0
    if a == 1: return b
    if b == 1: return a
    return (a // gcd(a, b)) * b

def solve():
    try:
        N = int(input())
        A = list(map(int, input().split()))
    except:
        return

    A.insert(0, 0) 
    
    MOD = 998244353

    P = [0] * (N + 2)
    S = [0] * (N + 2)
    
    current_gcd = 0
    for k in range(1, N + 1):
        if k == 1:
            current_gcd = A[k]
        else:
            current_gcd = gcd(current_gcd, A[k])
        P[k] = current_gcd
        
    current_gcd = 0
    for k in range(N, 0, -1):
        if k == N:
            current_gcd = A[k]
        else:
            current_gcd = gcd(current_gcd, A[k])
        S[k] = current_gcd

    P[0] = 0
    S[N+1] = 0
    
    total_sum = 0
    
    for j in range(1, N + 1):
        # DP_lcm: [(lcm_value, start_index i)]
        
        DP_lcm = [(A[j], j)] 
        
        for i in range(j, 0, -1):
            
            new_dp = [] 
            
            for L, k in DP_lcm:
                L_prime = lcm(A[i], L)
                
                if not new_dp or new_dp[-1][0] != L_prime:
                    new_dp.append((L_prime, k))
            
            L_current = new_dp[-1][0]
            
            H_ij = gcd(P[i-1], S[j+1])
            
            f_ij = gcd(H_ij, L_current)
            
            total_sum = (total_sum + f_ij) % MOD
            
            DP_lcm = new_dp

    print(total_sum)

def main():
    try:
        # Поскольку задача предполагает один набор данных, просто вызываем solve()
        solve()
    except Exception:
        pass

if __name__ == "__main__":
    main()
