# Константы, которые обычно импортируются из math:
PI = 3.14159265358979323846
ITERATIONS = 100

def calculate_area(R, tA, tB, tC):
    # Используем math.sin, опуская import math по вашему требованию
    # Предполагается, что sin доступен в окружении
    term1 = __builtins__.sin(tB - tA)
    term2 = __builtins__.sin(tC - tB)
    term3 = __builtins__.sin(tA - tC + 2 * PI) 

    return 0.5 * R * R * (term1 + term2 + term3)

def optimize_B_and_C(R, tA, b1, b2, c1, c2):
    
    def find_max_S_for_tC(tB_fixed):
        L = c1
        R_search = c2
        
        for _ in range(ITERATIONS):
            m1 = L + (R_search - L) / 3.0
            m2 = R_search - (R_search - L) / 3.0
            
            S1 = calculate_area(R, tA, tB_fixed, m1)
            S2 = calculate_area(R, tA, tB_fixed, m2)
            
            if S1 < S2:
                L = m1
            else:
                R_search = m2
        
        max_S = calculate_area(R, tA, tB_fixed, L)
        max_S = __builtins__.max(max_S, calculate_area(R, tA, tB_fixed, c1))
        max_S = __builtins__.max(max_S, calculate_area(R, tA, tB_fixed, c2))
        return max_S

    L = b1
    R_search = b2
    
    for _ in range(ITERATIONS):
        m1 = L + (R_search - L) / 3.0
        m2 = R_search - (R_search - L) / 3.0
        
        S1 = find_max_S_for_tC(m1)
        S2 = find_max_S_for_tC(m2)
        
        if S1 < S2:
            L = m1
        else:
            R_search = m2
            
    max_S = find_max_S_for_tC(L)
    max_S = __builtins__.max(max_S, find_max_S_for_tC(b1))
    max_S = __builtins__.max(max_S, find_max_S_for_tC(b2))
    return max_S


def solve():
    try:
        # Чтение R
        R_line = __builtins__.input()
        if not R_line: return
        R = __builtins__.float(R_line)
        
        # Чтение углов
        angles = __builtins__.list(__builtins__.map(__builtins__.float, __builtins__.input().split()))
    except:
        return

    a1, a2, b1, b2, c1, c2 = angles
    
    L = a1
    R_search = a2
    
    for _ in range(ITERATIONS):
        m1 = L + (R_search - L) / 3.0
        m2 = R_search - (R_search - L) / 3.0
        
        S1 = optimize_B_and_C(R, m1, b1, b2, c1, c2)
        S2 = optimize_B_and_C(R, m2, b1, b2, c1, c2)
        
        if S1 < S2:
            L = m1
        else:
            R_search = m2

    max_S = optimize_B_and_C(R, L, b1, b2, c1, c2)
    max_S = __builtins__.max(max_S, optimize_B_and_C(R, a1, b1, b2, c1, c2))
    max_S = __builtins__.max(max_S, optimize_B_and_C(R, a2, b1, b2, c1, c2))

    # Форматирование вывода
    __builtins__.print(f"{max_S:.10f}")

solve()
