def power(a, d, n):
    res = 1
    a = a % n
    while d > 0:
        if d & 1:
            res = (res * a) % n
        d >>= 1
        a = (a * a) % n
    return res

def is_prime(n):
    if n <= 1: return False
    if n <= 3: return True
    if n % 2 == 0: return False
    
    # Набор оснований для n < 2^64
    bases = [2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37]
    
    d = n - 1
    while d % 2 == 0:
        d //= 2
        
    for a in bases:
        if a >= n: break
        
        x = power(a, d, n)
        if x == 1 or x == n - 1:
            continue
            
        is_composite = True
        temp_d = d
        
        while temp_d != n - 1:
            x = (x * x) % n
            temp_d *= 2
            
            if x == n - 1:
                is_composite = False
                break
        
        if is_composite:
            return False
            
    return True

def get_nim_value(s):
    if s <= 3:
        return 0
    
    if is_prime(s):
        return 0
    
    if s == 4:
        return 1
    if s == 9:
        return 0
        
    if s % 2 != 0:
        return 1
    else:
        return 2

def solve():
    try:
        N_line = input()
        if not N_line: return
        N = int(N_line)
        
        S = list(map(int, input().split()))
    except EOFError:
        return
    except:
        return

    total_nim = 0
    
    for s in S:
        total_nim ^= get_nim_value(s)
        
    if total_nim != 0:
        print("Yes")
    else:
        print("No")

def main():
    try:
        T_line = input()
        if not T_line: return
        T = int(T_line)
        for _ in range(T):
            solve()
    except Exception:
        pass

if __name__ == "__main__":
    main()
