import sys
# Увеличиваем лимит рекурсии для работы с деревом отрезков
sys.setrecursionlimit(200000)

def solve():
    # Чтение n
    try:
        # Быстрое чтение N
        n = int(sys.stdin.readline())
    except EOFError:
        return
    except ValueError:
        return

    # Чтение a_i (используем 1-индексацию, a[0] остается неиспользованным)
    a = [0] + list(map(int, sys.stdin.readline().split()))

    # L[i]: максимальная длина нарастающей последовательности, ЗАКАНЧИВАЮЩЕЙСЯ на a[i]
    # (Например, для [3, 4, 5], L[3]=3)
    L = [0] * (n + 2)

    # R[i]: максимальная длина убывающей последовательности, ЗАКАНЧИВАЮЩЕЙСЯ на a[i]
    # (Например, для [5, 4, 3], R[3]=3)
    R = [0] * (n + 2)

    # Дерево отрезков (Segment Tree) для хранения max(V[i]), где V[i] = 2 * min(L[i], R[i]) - 1
    # Хранит максимальную длину ступенчатого палиндрома с центром в i
    tree = [0] * (4 * (n + 1))

    # --- Функции для Дерева Отрезков (Segment Tree) ---

    def update_tree(idx, val, node, start, end):
        """Обновляет значение в дереве отрезков."""
        if start == end:
            tree[node] = val
            return
        
        mid = (start + end) // 2
        if idx <= mid:
            update_tree(idx, val, 2 * node, start, mid)
        else:
            update_tree(idx, val, 2 * node + 1, mid + 1, end)
        
        # Пересчет максимума в родительском узле
        tree[node] = max(tree[2 * node], tree[2 * node + 1])

    def query_max_tree(node, start, end):
        """Запрос максимума на всем отрезке [1, n]."""
        # В данном случае всегда запрашиваем максимум по всему дереву
        return tree[1]

    # --- Функции для Пересчета L и R ---

    def recalculate_L_and_update(i):
        """Пересчитывает L_j для j >= i и обновляет ДО."""
        # Распространение вправо (j >= i)
        j = i
        while j <= n:
            old_L = L[j]
            
            if j == 1 or a[j] != a[j-1] + 1:
                L[j] = 1
            else:
                L[j] = L[j-1] + 1

            if L[j] != old_L:
                # Обновить V[j] и ДО, только если L[j] изменился
                V_j = 2 * min(L[j], R[j]) - 1
                update_tree(j, V_j, 1, 1, n)
                j += 1
            else:
                break # Распространение остановлено
        
    def recalculate_R_and_update(i):
        """Пересчитывает R_j для j <= i и обновляет ДО."""
        # Распространение влево (j <= i)
        j = i
        while j >= 1:
            old_R = R[j]
            
            if j == n or a[j] != a[j+1] + 1:
                R[j] = 1
            else:
                R[j] = R[j+1] + 1

            if R[j] != old_R:
                # Обновить V[j] и ДО, только если R[j] изменился
                V_j = 2 * min(L[j], R[j]) - 1
                update_tree(j, V_j, 1, 1, n)
                j -= 1
            else:
                break # Распространение остановлено

    # --- Инициализация ---

    # 1. Начальный расчет L
    for i in range(1, n + 1):
        if i == 1 or a[i] != a[i-1] + 1:
            L[i] = 1
        else:
            L[i] = L[i-1] + 1

    # 2. Начальный расчет R
    for i in range(n, 0, -1):
        if i == n or a[i] != a[i+1] + 1:
            R[i] = 1
        else:
            R[i] = R[i+1] + 1

    # 3. Построение Дерева Отрезков
    for i in range(1, n + 1):
        V_i = 2 * min(L[i], R[i]) - 1
        update_tree(i, V_i, 1, 1, n)

    # Вывод начального результата
    sys.stdout.write(f"{query_max_tree(1, 1, n)}\n")

    # --- Обработка Запросов ---

    try:
        q = int(sys.stdin.readline())
    except EOFError:
        q = 0
    except ValueError:
        q = 0


    for _ in range(q):
        try:
            line = sys.stdin.readline().split()
            if not line:
                break
            i = int(line[0])
            x = int(line[1])
        except EOFError:
            break
        except ValueError:
            break

        # Если высота не изменилась, просто выводим текущий максимум
        if a[i] == x:
            sys.stdout.write(f"{query_max_tree(1, 1, n)}\n")
            continue

        # 1. Обновить высоту куста
        a[i] = x

        # 2. Пересчитать и обновить L и R в обе стороны от i
        # Для i: L[i] зависит от L[i-1], R[i] зависит от R[i+1]
        
        # R-пересчет идет влево (R[i-1] зависит от R[i]) и включает i
        recalculate_R_and_update(i)
        
        # L-пересчет идет вправо (L[i+1] зависит от L[i]) и включает i
        recalculate_L_and_update(i)

        # 3. Вывод максимальной длины
        sys.stdout.write(f"{query_max_tree(1, 1, n)}\n")

if __name__ == "__main__":
    solve()
