import sys
# Увеличиваем лимит рекурсии для работы с деревом отрезков
sys.setrecursionlimit(200000)

def solve():
    # Настройка быстрого ввода/вывода
    input = sys.stdin.read
    data = input().split()
    
    if not data:
        return

    n = int(data[0])
    
    # 1-индексация для удобства (a[0] не используется)
    # data[1] до data[n] - это высоты a_i
    a = [0] + [int(x) for x in data[1:n+1]]
    
    if n == 0:
        return

    # L[i]: Длина нарастающей последовательности, заканчивающейся на a[i]
    L = [0] * (n + 2)
    # R[i]: Длина убывающей последовательности, заканчивающейся на a[i]
    R = [0] * (n + 2)

    # Дерево отрезков для хранения max(2 * min(L[i], R[i]) - 1)
    tree = [0] * (4 * (n + 1))
    
    # Индекс для чтения запросов
    data_idx = n + 1
    
    # --- Функции для Дерева Отрезков (Segment Tree) ---

    def update_tree(idx, val, node, start, end):
        """Обновляет значение в дереве отрезков."""
        if start == end:
            tree[node] = val
            return
        
        mid = (start + end) // 2
        if idx <= mid:
            update_tree(idx, val, 2 * node, start, mid)
        else:
            update_tree(idx, val, 2 * node + 1, mid + 1, end)
        
        # Пересчет максимума в родительском узле
        tree[node] = max(tree[2 * node], tree[2 * node + 1])

    def query_max_tree():
        """Запрос максимума на всем отрезке [1, n]."""
        # Максимум всегда находится в корне (node 1)
        return tree[1]

    # --- Функции для Пересчета L и R ---

    def recalculate_L_and_update(i):
        """Пересчитывает L_j для j >= i и обновляет ДО."""
        # 1. Пересчет L[i]
        j = i
        old_L_i = L[j]
        if j == 1 or a[j] != a[j-1] + 1:
            L[j] = 1
        else:
            L[j] = L[j-1] + 1
            
        if L[j] != old_L_i:
            V_j = 2 * min(L[j], R[j]) - 1
            update_tree(j, V_j, 1, 1, n)

        # 2. Распространение вправо (j > i)
        j = i + 1
        while j <= n:
            old_L = L[j]
            
            # L[j] зависит только от L[j-1] и a[j], a[j-1]
            if a[j] == a[j-1] + 1:
                L[j] = L[j-1] + 1
            else:
                L[j] = 1

            if L[j] != old_L:
                V_j = 2 * min(L[j], R[j]) - 1
                update_tree(j, V_j, 1, 1, n)
                j += 1
            else:
                break # Распространение остановлено

    def recalculate_R_and_update(i):
        """Пересчитывает R_j для j <= i и обновляет ДО."""
        # 1. Пересчет R[i]
        j = i
        old_R_i = R[j]
        
        if j == n or a[j] != a[j+1] + 1:
            R[j] = 1
        else:
            R[j] = R[j+1] + 1
            
        if R[j] != old_R_i:
            V_j = 2 * min(L[j], R[j]) - 1
            update_tree(j, V_j, 1, 1, n)

        # 2. Распространение влево (j < i)
        j = i - 1
        while j >= 1:
            old_R = R[j]
            
            # R[j] зависит только от R[j+1] и a[j], a[j+1]
            if a[j] == a[j+1] + 1:
                R[j] = R[j+1] + 1
            else:
                R[j] = 1

            if R[j] != old_R:
                V_j = 2 * min(L[j], R[j]) - 1
                update_tree(j, V_j, 1, 1, n)
                j -= 1
            else:
                break # Распространение остановлено

    # --- Инициализация ---

    # 1. Начальный расчет L (слева направо)
    for i in range(1, n + 1):
        if i == 1 or a[i] != a[i-1] + 1:
            L[i] = 1
        else:
            L[i] = L[i-1] + 1

    # 2. Начальный расчет R (справа налево)
    for i in range(n, 0, -1):
        if i == n or a[i] != a[i+1] + 1:
            R[i] = 1
        else:
            R[i] = R[i+1] + 1

    # 3. Построение Дерева Отрезков
    for i in range(1, n + 1):
        V_i = 2 * min(L[i], R[i]) - 1
        update_tree(i, V_i, 1, 1, n)

    # Вывод начального результата
    output = [str(query_max_tree())]

    # --- Обработка Запросов ---
    
    if data_idx >= len(data):
        sys.stdout.write("\n".join(output) + "\n")
        return

    q = int(data[data_idx])
    data_idx += 1

    for _ in range(q):
        if data_idx + 1 >= len(data):
            break
            
        i = int(data[data_idx])
        x = int(data[data_idx+1])
        data_idx += 2

        # Если высота не изменилась
        if a[i] == x:
            output.append(str(query_max_tree()))
            continue

        # 1. Обновить высоту куста
        a[i] = x

        # 2. Пересчет и обновление L и R:
        # Важно: L-значения зависят от L[i-1], R-значения от R[i+1].
        # Поэтому R-распространение идет влево, L-распространение идет вправо.
        # R_i и L_i должны быть пересчитаны до того, как они повлияют на соседей.
        
        # Пересчет R (влево от i и R[i])
        recalculate_R_and_update(i)
        
        # Пересчет L (вправо от i и L[i])
        recalculate_L_and_update(i)

        # 3. Вывод максимальной длины
        output.append(str(query_max_tree()))

    sys.stdout.write("\n".join(output) + "\n")

if __name__ == "__main__":
    solve()
