def solve():
    try:
        # Чтение N
        N_line = __builtins__.input()
        if not N_line: return
        N = __builtins__.int(N_line)
        
        # Чтение N песен
        main_queue = []
        for _ in range(N):
            parts = __builtins__.input().split()
            main_queue.append({'name': parts[0], 'len': __builtins__.int(parts[1])})
        
        # Чтение M
        M_line = __builtins__.input()
        if not M_line: return
        M = __builtins__.int(M_line)
        
        # Чтение M событий
        events = []
        for _ in range(M):
            parts = __builtins__.input().split()
            events.append({
                't': __builtins__.int(parts[0]), 
                'name': parts[1], 
                'len': __builtins__.int(parts[2])
            })
    except:
        return

    # Инициализация
    queue_idx = 0
    next_up = [] # Стек для "Играть следующей"
    event_idx = 0
    current_time = 0
    output = []
    
    # Основной цикл: пока есть песни в очередях ИЛИ есть необработанные события
    while queue_idx < N or next_up or event_idx < M:
        
        # a. и b. Обработка событий, которые произошли к текущему моменту, 
        # и синхронизация времени, если очереди пусты.
        
        if queue_idx >= N and not next_up and event_idx < M:
            # Если нет песен, но есть события, ждем ближайшего события.
            current_time = __builtins__.max(current_time, events[event_idx]['t'])
            
        # Обрабатываем все события, наступившие до current_time (или в current_time)
        while event_idx < M and events[event_idx]['t'] <= current_time:
            # Добавление в next_up (стек)
            next_up.append(events[event_idx])
            event_idx += 1
            
        # c. Выбор следующей песни
        P = None
        if next_up:
            P = next_up.pop()
        elif queue_idx < N:
            P = main_queue[queue_idx]
            queue_idx += 1
        
        if P is None:
            # Если нет песен, но и событий больше нет, цикл прервется
            break

        # d. Воспроизведение
        song_start_time = current_time
        song_end_time = song_start_time + P['len']
        
        output.append((P['name'], song_start_time))
        
        # e. Обработка событий во время воспроизведения
        while event_idx < M and events[event_idx]['t'] <= song_end_time:
            # Добавление в next_up (стек)
            next_up.append(events[event_idx])
            event_idx += 1
            
        # f. Обновление времени
        current_time = song_end_time

    # Вывод результата
    for name, start_time in output:
        __builtins__.print(f"{name} {start_time}")

solve()
