# Функция для вычисления НОД (GCD) с помощью алгоритма Евклида
def gcd(a, b):
    a = abs(a)
    b = abs(b)
    while b:
        a, b = b, a % b
    return a

def solve():
    # --- Чтение данных ---
    try:
        # Чтение N, M, L
        line1 = input()
        if not line1:
            return
        parts = line1.split()
        N = int(parts[0])
        M = int(parts[1])
        L = int(parts[2])
        
        # Чтение рёбер
        edges = []
        for _ in range(M):
            u, v, w = map(int, input().split())
            edges.append((u, v, w))

        # Чтение требуемых кратчайших расстояний D
        D = list(map(int, input().split()))
        
    except EOFError:
        return
    except Exception:
        # Если чтение не удалось, завершаем
        return

    # d_v для вершины v находится в D[v-1]
    MOD = 1000000007
    
    # --- 1. Предварительная проверка и инициализация ---
    
    if D[0] != 0:
        print(0)
        return

    for u, v, w in edges:
        if w != -1:
            # Проверка: |du - dv| <= w
            diff = abs(D[u-1] - D[v-1])
            if diff > w:
                print(0)
                return

    # Подготовка вершин для сортировки: (расстояние, вершина)
    sorted_nodes = []
    for v in range(1, N + 1):
        sorted_nodes.append((D[v-1], v))
    
    # Сортировка по расстоянию (D[v-1])
    # Это имитирует работу Дейкстры
    sorted_nodes.sort() 
    
    edge_used = {}
    total_ways = 1

    # --- 2. Обработка Вершин ---

    for d_v, v in sorted_nodes:
        if v == 1:
            continue
        
        S_v = [] # Соседи u, где d_u < d_v
        for u, v_e, w in edges:
            u_idx = u - 1
            v_idx = v_e - 1

            # Ребро (u, v)
            if v_e == v and D[u_idx] < d_v:
                S_v.append((u, w))
            # Ребро (v, u)
            elif u == v and D[v_idx] < d_v:
                S_v.append((v_e, w))

        if d_v > 0 and not S_v:
            print(0)
            return

        # Проверка фиксации известным ребром
        fixed_by_known = False
        for u, w in S_v:
            if w != -1 and D[u-1] + w == d_v:
                fixed_by_known = True
                break

        unknown_edges = []
        for u, w in S_v:
            if w == -1:
                edge_key = tuple(sorted((u, v)))
                unknown_edges.append((u, edge_key))
        
        # --- Комбинаторика ---
        
        if fixed_by_known:
            # Случай A: Фиксация известным ребром
            for u, edge_key in unknown_edges:
                w_required_min = d_v - D[u-1] + 1
                
                count = max(0, L - w_required_min + 1)
                
                total_ways = (total_ways * count) % MOD
                edge_used[edge_key] = True

        else:
            # Случай B: Должно быть установлено хотя бы одним неизвестным ребром
            
            if not unknown_edges and len(S_v) > 0:
                # Нет неизвестных, нет фиксации известным, но есть соседи с меньшим D. Ответ 0.
                print(0)
                return
            
            C_all = 1 
            C_non_critical = 1 
            
            for u, edge_key in unknown_edges:
                w_required = d_v - D[u-1]
                
                # Если w_required вне [1, L], это невозможно
                if not (1 <= w_required <= L):
                    print(0)
                    return
                
                # 1. C_all: w >= w_required (диапазон [w_required, L])
                count_all = max(0, L - w_required + 1)
                C_all = (C_all * count_all) % MOD
                
                # 2. C_non_critical: w > w_required (диапазон [w_required + 1, L])
                count_non_critical = max(0, L - (w_required + 1) + 1)
                C_non_critical = (C_non_critical * count_non_critical) % MOD
                
                edge_used[edge_key] = True

            # R_v = C_all - C_non_critical
            R_v = (C_all - C_non_critical + MOD) % MOD
            total_ways = (total_ways * R_v) % MOD


    # --- 3. Учет оставшихся необязательных неизвестных рёбер ---
    
    for u, v, w in edges:
        if w == -1:
            edge_key = tuple(sorted((u, v)))
            
            if edge_key not in edge_used:
                # Ребро не было критичным для d_u или d_v
                
                # Условие: w >= |d_u - d_v|
                required_w_min = abs(D[u-1] - D[v-1])
                
                # Количество способов: [required_w_min, L]
                count = max(0, L - required_w_min + 1)
                
                total_ways = (total_ways * count) % MOD

    print(total_ways)


def main():
    try:
        # Чтение количества тестовых случаев T
        T = int(input())
        
        for _ in range(T):
            solve()
            
    except Exception:
        pass

if __name__ == "__main__":
    main()
