import sys

# Установка модуля
MOD = 998244353

# Расширенный алгоритм Евклида для обратного элемента по модулю
def inverse(a):
    # Нахождение a^{-1} mod MOD, используя малую теорему Ферма (MOD - простое число)
    return pow(a, MOD - 2, MOD)

# Вычисление суммы S_k(x) = \sum_{i=1}^{x} i^k mod MOD
def sum_of_powers(x, k):
    if x == 0:
        return 0
    x %= MOD
    
    if k == 1:
        # S_1(x) = x * (x + 1) / 2
        res = (x * (x + 1)) % MOD
        res = (res * inverse(2)) % MOD
        return res
    
    if k == 2:
        # S_2(x) = x * (x + 1) * (2x + 1) / 6
        res = (x * (x + 1)) % MOD
        res = (res * (2 * x + 1)) % MOD
        res = (res * inverse(6)) % MOD
        return res
    
    return 0 # Для других степеней не используется

def solve():
    try:
        # Чтение N
        N_str = sys.stdin.readline()
        if not N_str: return
        N = int(N_str.strip())
    except:
        return

    # N по модулю
    n_mod = N % MOD
    
    # --- 1. Вычисление S_1 = n^2(n+1)/2 ---
    # S1 = sum_{i=1}^n sum_{j=1}^n i
    S1 = (n_mod * n_mod) % MOD
    S1 = (S1 * (n_mod + 1)) % MOD
    S1 = (S1 * inverse(2)) % MOD

    # --- 2. Вычисление S_2 = sum_{j=1}^n j * sum_{i=1}^n floor(i/j) ---
    S2 = 0
    
    # Итерация по q = floor(n/j), q меняется O(sqrt(n)) раз
    q = 1
    while q <= N:
        R_q = N // q # R_q = floor(n/q)
        L_q = N // (q + 1) + 1 # L_q = floor(n/(q+1)) + 1
        
        # Диапазон [L_q, R_q] содержит j, для которых floor(n/j) = q.
        # Мы суммируем по j в этом диапазоне.
        
        if L_q > R_q:
             # Если диапазон пуст, переходим к следующему q.
             # Это происходит только если q > N, что не должно случиться в цикле,
             # но как мера предосторожности.
             break

        # T_j = -q(q+1)/2 * j + q(n+1)
        
        # Константы по модулю
        q_mod = q % MOD
        
        C1 = (q_mod * (q_mod + 1)) % MOD
        C1 = (C1 * inverse(2)) % MOD
        C1 = (MOD - C1) % MOD # C1 = -q(q+1)/2 mod M
        
        C2 = (q_mod * (n_mod + 1)) % MOD # C2 = q(n+1) mod M

        # Сумма S_block = C1 * sum_{j=L}^{R} j^2 + C2 * sum_{j=L}^{R} j
        
        # Sum j^2: S_2(R_q) - S_2(L_q - 1)
        S_j2 = (sum_of_powers(R_q, 2) - sum_of_powers(L_q - 1, 2) + MOD) % MOD
        
        # Sum j: S_1(R_q) - S_1(L_q - 1)
        S_j1 = (sum_of_powers(R_q, 1) - sum_of_powers(L_q - 1, 1) + MOD) % MOD
        
        S_block = (C1 * S_j2) % MOD
        S_block = (S_block + (C2 * S_j1) % MOD) % MOD
        
        S2 = (S2 + S_block) % MOD
        
        # Переход к следующему блоку. Следующий q будет floor(n / (R_q + 1)).
        # Но поскольку мы итерируем q по порядку, просто увеличиваем q.
        q += 1
        
    # --- 3. Финальный ответ S = S_1 - S_2 ---
    result = (S1 - S2 + MOD) % MOD

    print(result)

if __name__ == "__main__":
    solve()
