#include "bits/stdc++.h"
using namespace std;


struct Node {
    int prefPlus = 0, suffPlus = 0, bestPlus = 0;
    int prefMinus = 0, suffMinus = 0, bestMinus = 0;
    int bestStep = 0;
    int len = 0;
};

Node make_nodes_from_givenValue(long long val) {
    Node res;
    res.len = 1;
    if (val == 1) {
        res.prefPlus = res.suffPlus = res.bestPlus = 1;
    } else if (val == -1) {
        res.prefMinus = res.suffMinus = res.bestMinus = 1;
    }
    return res;
}

Node merge_nodes(const Node L, const Node R) {

    if (L.len == 0) return R;
    if (R.len == 0) return L;
    Node result;
    result.len = L.len + R.len;
    int lenL = L.len, lenR = R.len;

    result.prefPlus = L.prefPlus;
    if (L.prefPlus == lenL) result.prefPlus = lenL + R.prefPlus;

    result.suffPlus = R.suffPlus;
    if (R.suffPlus == lenR) result.suffPlus = lenR + L.suffPlus;

    result.bestPlus = max({L.bestPlus, R.bestPlus, L.suffPlus + R.prefPlus});

    result.prefMinus = L.prefMinus;
    if (L.prefMinus == lenL) result.prefMinus = lenL + R.prefMinus;

    result.suffMinus = R.suffMinus;
    if (R.suffMinus == lenR) result.suffMinus = lenR + L.suffMinus;

    result.bestMinus = max({L.bestMinus, R.bestMinus, L.suffMinus + R.prefMinus});

    result.bestStep = max(L.bestStep, R.bestStep);
    if (L.suffPlus > 0 && R.prefMinus > 0) {
        int cross = min(L.suffPlus, R.prefMinus);
        result.bestStep = max(result.bestStep, cross);
    }

    return result;
}

int main() {

    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    if (!(cin >> n)) return 0;
    vector<long long> a(n);
    for (int i = 0; i < n; ++i) cin >> a[i];

    int queries;
    cin >> queries;

    if (n == 1) {
        cout << 1 << endl;
        for (int k = 0; k < queries; ++k) {
            int i;
            long long x;
            cin >> i >> x;
            cout << 1 << endl;
        }
        return 0;
    }

    int m = n - 1;
    int size = 1;
    while (size < m) size <<= 1;
    vector<Node> seg(2 * size);

    vector<long long> b(m);
    for (int i = 0; i < m; ++i) {
        b[i] = a[i + 1] - a[i];
        seg[size + i] = make_nodes_from_givenValue(b[i]);
    }
    for (int i = size - 1; i > 0; --i) {
        seg[i] = merge_nodes(seg[2 * i], seg[2 * i + 1]);
    }

    auto get_result = [&]() {
        int bestStep = seg[1].bestStep;
        int ans = max(1, 2 * bestStep + 1);
        return ans;
    };

    auto point_update = [&](int pos) {

        long long val = a[pos + 1] - a[pos];
        b[pos] = val;
        int idx = size + pos;
        seg[idx] = make_nodes_from_givenValue(val);
        idx >>= 1;
        while (idx) {
            seg[idx] = merge_nodes(seg[2 * idx], seg[2 * idx + 1]);
            idx >>= 1;
        }
    };

    cout << get_result() << endl;

    for (int qi = 0; qi < queries; ++qi) {
        int i;
        long long x;
        cin >> i >> x;

        i--;
        a[i] = x;

        if (i - 1 >= 0)   point_update(i - 1);
        if (i < n - 1)    point_update(i);

        cout << get_result() << endl;
    }


    return 0;
}