#include "bits/stdc++.h"
using namespace std;

struct Song {
    string name;
    long long len;
};

struct Event {
    long long t;
    string name;
    long long len;
};

int main() {

    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    if (!(cin >> n)) return 0;

    deque<Song> q;
    for (int i = 0; i < n; ++i) {
        Song s;

        cin >> s.name >> s.len;
        q.push_back(s);
    }

    int m;
    cin >> m;
    vector<Event> myEvents(m);

    for (int i = 0; i < m; ++i) {
        cin >> myEvents[i].t >> myEvents[i].name >> myEvents[i].len;
    }

    long long currentTime = 0;
    int j = 0;
    vector<pair<string, long long>> ans;

    while (!q.empty() || j < m) {

        if (q.empty()) {
            long long t = myEvents[j].t;
            if (currentTime < t) currentTime = t;

            while (j < m && myEvents[j].t == t) {
                q.push_front({myEvents[j].name, myEvents[j].len});
                ++j;
            }
        }

        Song cur = q.front();
        q.pop_front();

        long long start = currentTime;
        ans.push_back({cur.name, start});

        long long finish = start + cur.len;

        while (j < m && myEvents[j].t <= finish) {
            q.push_front({myEvents[j].name, myEvents[j].len});
            ++j;
        }

        currentTime = finish;
    }

    for (auto p : ans) {
        cout << p.first << ' ' << p.second << endl;
    }

    return 0;
}
