import sys
from collections import deque

input = sys.stdin.readline

n = int(input())
q = deque()
for _ in range(n):
    name, ln = input().split()
    q.append((name, int(ln)))

m = int(input())
events = []
for _ in range(m):
    t, name, ln = input().split()
    events.append((int(t), name, int(ln)))

res = []
cur_time = 0

# Если очередь не пуста — узнаём, когда закончится первая песня
if q:
    finish = q[0][1]
else:
    finish = 10**30

i = 0  # индекс события

while q or i < m:
    # если есть событие, и оно случается раньше окончания текущей песни
    if i < m and events[i][0] < finish:
        t, nm, ln = events[i]
        i += 1
        q.appendleft((nm, ln))   # добавляем в начало
        continue

    # иначе — текущая песня заканчивается
    name, ln = q.popleft()
    res.append((name, cur_time))
    cur_time += ln

    # если остались песни — обновляем finish_time
    if q:
        finish = cur_time + q[0][1]
    else:
        finish = 10**30

    # если следующая песня начинается позже события — можно обработать событие на том же времени
    if i < m and events[i][0] == cur_time:
        t, nm, ln = events[i]
        i += 1
        q.appendleft((nm, ln))
        finish = cur_time + ln

# вывод результата
for name, st in res:
    print(name, st)