#include <iostream>
#include <vector>
#include <cmath>
using namespace std;

int gcd(int a, int b) {
    while (b) {
        int tmp = b;
        b = a % b;
        a = tmp;
    }
    return a;
}

bool can_cut(int x){
    if (x < 2) return false;
    for (int d = 2; d<=x/2; d++){
        if (x%d == 0){
            int a = d;
            int b = x - d;
            if (gcd(a,b) > 1) return true;
        }
    }
    return false;
}

int main () {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int t;
    cin >> t;
    while(t--) {
        int n;
        cin >> n;
        bool can_win = false;
        vector<int> a(n);
        for (int i = 0; i<n; ++i){
            if (can_cut(a[i])){
                can_win = true;
                break;
            }
        }
        if (can_win)
            cout << "yes\n";
        else
            cout << "no\n";
    }
    return 0;
}
