#include <bits/stdc++.h>
using namespace std;

using ll = long long;
const int MOD = 998244353;

ll lcm(ll a, ll b) {
    return a / __gcd(a, b) * b;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<int> a(n);
    for (int i = 0; i < n; ++i) cin >> a[i];

    vector<int> prefix_gcd(n + 2, 0), suffix_gcd(n + 2, 0);

    for (int i = 1; i <= n; ++i)
        prefix_gcd[i] = __gcd(prefix_gcd[i - 1], a[i - 1]);
    for (int i = n; i >= 1; --i)
        suffix_gcd[i] = __gcd(suffix_gcd[i + 1], a[i - 1]);

    ll ans = 0;

    for (int i = 0; i < n; ++i) {
        ll curr_lcm = a[i];
        for (int j = i; j < n; ++j) {
            if (j > i) {
                curr_lcm = lcm(curr_lcm, (ll)a[j]);
                if (curr_lcm > 1e18) break; // защита от переполнения
            }
            ll outside_gcd = __gcd(prefix_gcd[i], suffix_gcd[j+2]);
            ll total_gcd = __gcd(curr_lcm, outside_gcd);
            ans = (ans + total_gcd) % MOD;
        }
    }

    cout << ans << "\n";
    return 0;
}
